@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.DiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Lightsail Disk resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.lightsail.Disk;
 * import com.pulumi.aws.lightsail.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .filters(GetAvailabilityZonesFilterArgs.builder()
 *                 .name("opt-in-status")
 *                 .values("opt-in-not-required")
 *                 .build())
 *             .build());
 *         var test = new Disk("test", DiskArgs.builder()
 *             .sizeInGb(8)
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_disk` using the name attribute. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/disk:Disk test test
 * ```
 * @property availabilityZone The Availability Zone in which to create your disk.
 * @property name The name of the Lightsail load balancer.
 * @property sizeInGb The instance port the load balancer will connect.
 * @property tags A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class DiskArgs(
    public val availabilityZone: Output<String>? = null,
    public val name: Output<String>? = null,
    public val sizeInGb: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.DiskArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.DiskArgs =
        com.pulumi.aws.lightsail.DiskArgs.builder()
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .sizeInGb(sizeInGb?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DiskArgs].
 */
@PulumiTagMarker
public class DiskArgsBuilder internal constructor() {
    private var availabilityZone: Output<String>? = null

    private var name: Output<String>? = null

    private var sizeInGb: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The Availability Zone in which to create your disk.
     */
    @JvmName("awcfcnsivtvraqwp")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value The name of the Lightsail load balancer.
     */
    @JvmName("rueqmhqoatrislvg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The instance port the load balancer will connect.
     */
    @JvmName("markcrmaoiodstub")
    public suspend fun sizeInGb(`value`: Output<Int>) {
        this.sizeInGb = value
    }

    /**
     * @param value A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dbfhtelcacrcebbt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Availability Zone in which to create your disk.
     */
    @JvmName("xcwccwvggxkwasbq")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value The name of the Lightsail load balancer.
     */
    @JvmName("isqiknpxtmfnagqa")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The instance port the load balancer will connect.
     */
    @JvmName("ojrvwlybljiaapec")
    public suspend fun sizeInGb(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizeInGb = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("klymutfunfeweelk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eqlepveybfaotfym")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DiskArgs = DiskArgs(
        availabilityZone = availabilityZone,
        name = name,
        sizeInGb = sizeInGb,
        tags = tags,
    )
}
