@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Disk_attachment].
 */
@PulumiTagMarker
public class Disk_attachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: Disk_attachmentArgs = Disk_attachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend Disk_attachmentArgsBuilder.() -> Unit) {
        val builder = Disk_attachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Disk_attachment {
        val builtJavaResource = com.pulumi.aws.lightsail.Disk_attachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Disk_attachment(builtJavaResource)
    }
}

/**
 * Attaches a Lightsail disk to a Lightsail Instance
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.lightsail.Disk;
 * import com.pulumi.aws.lightsail.DiskArgs;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.Disk_attachment;
 * import com.pulumi.aws.lightsail.Disk_attachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .filters(GetAvailabilityZonesFilterArgs.builder()
 *                 .name("opt-in-status")
 *                 .values("opt-in-not-required")
 *                 .build())
 *             .build());
 *         var testDisk = new Disk("testDisk", DiskArgs.builder()
 *             .sizeInGb(8)
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .build());
 *         var testInstance = new Instance("testInstance", InstanceArgs.builder()
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_1_0")
 *             .build());
 *         var testDisk_attachment = new Disk_attachment("testDisk_attachment", Disk_attachmentArgs.builder()
 *             .diskName(testDisk.name())
 *             .instanceName(testInstance.name())
 *             .diskPath("/dev/xvdf")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_disk` using the id attribute. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/disk_attachment:Disk_attachment test test-disk,test-instance
 * ```
 *
 */
public class Disk_attachment internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.Disk_attachment,
) : KotlinCustomResource(javaResource, Disk_attachmentMapper) {
    /**
     * The name of the Lightsail Disk.
     */
    public val diskName: Output<String>
        get() = javaResource.diskName().applyValue({ args0 -> args0 })

    /**
     * The disk path to expose to the instance.
     */
    public val diskPath: Output<String>
        get() = javaResource.diskPath().applyValue({ args0 -> args0 })

    /**
     * The name of the Lightsail Instance to attach to.
     */
    public val instanceName: Output<String>
        get() = javaResource.instanceName().applyValue({ args0 -> args0 })
}

public object Disk_attachmentMapper : ResourceMapper<Disk_attachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.Disk_attachment::class == javaResource::class

    override fun map(javaResource: Resource): Disk_attachment = Disk_attachment(
        javaResource as
            com.pulumi.aws.lightsail.Disk_attachment,
    )
}

/**
 * @see [Disk_attachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Disk_attachment].
 */
public suspend fun disk_attachment(
    name: String,
    block: suspend Disk_attachmentResourceBuilder.() -> Unit,
): Disk_attachment {
    val builder = Disk_attachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Disk_attachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun disk_attachment(name: String): Disk_attachment {
    val builder = Disk_attachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
