@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.Disk_attachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Attaches a Lightsail disk to a Lightsail Instance
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.lightsail.Disk;
 * import com.pulumi.aws.lightsail.DiskArgs;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.Disk_attachment;
 * import com.pulumi.aws.lightsail.Disk_attachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .filters(GetAvailabilityZonesFilterArgs.builder()
 *                 .name("opt-in-status")
 *                 .values("opt-in-not-required")
 *                 .build())
 *             .build());
 *         var testDisk = new Disk("testDisk", DiskArgs.builder()
 *             .sizeInGb(8)
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .build());
 *         var testInstance = new Instance("testInstance", InstanceArgs.builder()
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_1_0")
 *             .build());
 *         var testDisk_attachment = new Disk_attachment("testDisk_attachment", Disk_attachmentArgs.builder()
 *             .diskName(testDisk.name())
 *             .instanceName(testInstance.name())
 *             .diskPath("/dev/xvdf")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_disk` using the id attribute. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/disk_attachment:Disk_attachment test test-disk,test-instance
 * ```
 * @property diskName The name of the Lightsail Disk.
 * @property diskPath The disk path to expose to the instance.
 * @property instanceName The name of the Lightsail Instance to attach to.
 */
public data class Disk_attachmentArgs(
    public val diskName: Output<String>? = null,
    public val diskPath: Output<String>? = null,
    public val instanceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.Disk_attachmentArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.Disk_attachmentArgs =
        com.pulumi.aws.lightsail.Disk_attachmentArgs.builder()
            .diskName(diskName?.applyValue({ args0 -> args0 }))
            .diskPath(diskPath?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [Disk_attachmentArgs].
 */
@PulumiTagMarker
public class Disk_attachmentArgsBuilder internal constructor() {
    private var diskName: Output<String>? = null

    private var diskPath: Output<String>? = null

    private var instanceName: Output<String>? = null

    /**
     * @param value The name of the Lightsail Disk.
     */
    @JvmName("ohfsirbvqtliwmyl")
    public suspend fun diskName(`value`: Output<String>) {
        this.diskName = value
    }

    /**
     * @param value The disk path to expose to the instance.
     */
    @JvmName("liauxgfboqrbtykt")
    public suspend fun diskPath(`value`: Output<String>) {
        this.diskPath = value
    }

    /**
     * @param value The name of the Lightsail Instance to attach to.
     */
    @JvmName("pvlcedgeesyngukj")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The name of the Lightsail Disk.
     */
    @JvmName("taenkuyqccnpqmsi")
    public suspend fun diskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskName = mapped
    }

    /**
     * @param value The disk path to expose to the instance.
     */
    @JvmName("ptjwmrrrkhhmovcf")
    public suspend fun diskPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskPath = mapped
    }

    /**
     * @param value The name of the Lightsail Instance to attach to.
     */
    @JvmName("gnremiygaswmhtap")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    internal fun build(): Disk_attachmentArgs = Disk_attachmentArgs(
        diskName = diskName,
        diskPath = diskPath,
        instanceName = instanceName,
    )
}
