@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.kotlin.outputs.DistributionCacheBehavior
import com.pulumi.aws.lightsail.kotlin.outputs.DistributionCacheBehaviorSettings
import com.pulumi.aws.lightsail.kotlin.outputs.DistributionDefaultCacheBehavior
import com.pulumi.aws.lightsail.kotlin.outputs.DistributionLocation
import com.pulumi.aws.lightsail.kotlin.outputs.DistributionOrigin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.lightsail.kotlin.outputs.DistributionCacheBehavior.Companion.toKotlin as distributionCacheBehaviorToKotlin
import com.pulumi.aws.lightsail.kotlin.outputs.DistributionCacheBehaviorSettings.Companion.toKotlin as distributionCacheBehaviorSettingsToKotlin
import com.pulumi.aws.lightsail.kotlin.outputs.DistributionDefaultCacheBehavior.Companion.toKotlin as distributionDefaultCacheBehaviorToKotlin
import com.pulumi.aws.lightsail.kotlin.outputs.DistributionLocation.Companion.toKotlin as distributionLocationToKotlin
import com.pulumi.aws.lightsail.kotlin.outputs.DistributionOrigin.Companion.toKotlin as distributionOriginToKotlin

/**
 * Builder for [Distribution].
 */
@PulumiTagMarker
public class DistributionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DistributionArgs = DistributionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DistributionArgsBuilder.() -> Unit) {
        val builder = DistributionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Distribution {
        val builtJavaResource = com.pulumi.aws.lightsail.Distribution(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Distribution(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Lightsail Distribution.
 * ## Example Usage
 * ### Basic Usage
 * Below is a basic example with a bucket as an origin.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Bucket;
 * import com.pulumi.aws.lightsail.BucketArgs;
 * import com.pulumi.aws.lightsail.Distribution;
 * import com.pulumi.aws.lightsail.DistributionArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionOriginArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionDefaultCacheBehaviorArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsForwardedCookiesArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsForwardedHeadersArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsForwardedQueryStringsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testBucket = new Bucket("testBucket", BucketArgs.builder()
 *             .bundleId("small_1_0")
 *             .build());
 *         var testDistribution = new Distribution("testDistribution", DistributionArgs.builder()
 *             .bundleId("small_1_0")
 *             .origin(DistributionOriginArgs.builder()
 *                 .name(testBucket.name())
 *                 .regionName(testBucket.region())
 *                 .build())
 *             .defaultCacheBehavior(DistributionDefaultCacheBehaviorArgs.builder()
 *                 .behavior("cache")
 *                 .build())
 *             .cacheBehaviorSettings(DistributionCacheBehaviorSettingsArgs.builder()
 *                 .allowedHttpMethods("GET,HEAD,OPTIONS,PUT,PATCH,POST,DELETE")
 *                 .cachedHttpMethods("GET,HEAD")
 *                 .defaultTtl(86400)
 *                 .maximumTtl(31536000)
 *                 .minimumTtl(0)
 *                 .forwardedCookies(DistributionCacheBehaviorSettingsForwardedCookiesArgs.builder()
 *                     .option("none")
 *                     .build())
 *                 .forwardedHeaders(DistributionCacheBehaviorSettingsForwardedHeadersArgs.builder()
 *                     .option("default")
 *                     .build())
 *                 .forwardedQueryStrings(DistributionCacheBehaviorSettingsForwardedQueryStringsArgs.builder()
 *                     .option(false)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### instance origin example
 * Below is an example of an instance as the origin.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.lightsail.StaticIp;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.StaticIpAttachment;
 * import com.pulumi.aws.lightsail.StaticIpAttachmentArgs;
 * import com.pulumi.aws.lightsail.Distribution;
 * import com.pulumi.aws.lightsail.DistributionArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionOriginArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionDefaultCacheBehaviorArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .filters(GetAvailabilityZonesFilterArgs.builder()
 *                 .name("opt-in-status")
 *                 .values("opt-in-not-required")
 *                 .build())
 *             .build());
 *         var testStaticIp = new StaticIp("testStaticIp");
 *         var testInstance = new Instance("testInstance", InstanceArgs.builder()
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("micro_1_0")
 *             .build());
 *         var testStaticIpAttachment = new StaticIpAttachment("testStaticIpAttachment", StaticIpAttachmentArgs.builder()
 *             .staticIpName(testStaticIp.name())
 *             .instanceName(testInstance.name())
 *             .build());
 *         var testDistribution = new Distribution("testDistribution", DistributionArgs.builder()
 *             .bundleId("small_1_0")
 *             .origin(DistributionOriginArgs.builder()
 *                 .name(testInstance.name())
 *                 .regionName(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.id()))
 *                 .build())
 *             .defaultCacheBehavior(DistributionDefaultCacheBehaviorArgs.builder()
 *                 .behavior("cache")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(testStaticIpAttachment)
 *                 .build());
 *     }
 * }
 * ```
 * ### lb origin example
 * Below is an example with a load balancer as an origin
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.lightsail.Lb;
 * import com.pulumi.aws.lightsail.LbArgs;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.LbAttachment;
 * import com.pulumi.aws.lightsail.LbAttachmentArgs;
 * import com.pulumi.aws.lightsail.Distribution;
 * import com.pulumi.aws.lightsail.DistributionArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionOriginArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionDefaultCacheBehaviorArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .filters(GetAvailabilityZonesFilterArgs.builder()
 *                 .name("opt-in-status")
 *                 .values("opt-in-not-required")
 *                 .build())
 *             .build());
 *         var testLb = new Lb("testLb", LbArgs.builder()
 *             .healthCheckPath("/")
 *             .instancePort("80")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *         var testInstance = new Instance("testInstance", InstanceArgs.builder()
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_1_0")
 *             .build());
 *         var testLbAttachment = new LbAttachment("testLbAttachment", LbAttachmentArgs.builder()
 *             .lbName(testLb.name())
 *             .instanceName(testInstance.name())
 *             .build());
 *         var testDistribution = new Distribution("testDistribution", DistributionArgs.builder()
 *             .bundleId("small_1_0")
 *             .origin(DistributionOriginArgs.builder()
 *                 .name(testLb.name())
 *                 .regionName(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.id()))
 *                 .build())
 *             .defaultCacheBehavior(DistributionDefaultCacheBehaviorArgs.builder()
 *                 .behavior("cache")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(testLbAttachment)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Lightsail Distribution using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/distribution:Distribution example rft-8012925589
 * ```
 *
 */
public class Distribution internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.Distribution,
) : KotlinCustomResource(javaResource, DistributionMapper) {
    /**
     * The alternate domain names of the distribution.
     */
    public val alternativeDomainNames: Output<List<String>>
        get() = javaResource.alternativeDomainNames().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The Amazon Resource Name (ARN) of the distribution.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Bundle ID to use for the distribution.
     */
    public val bundleId: Output<String>
        get() = javaResource.bundleId().applyValue({ args0 -> args0 })

    /**
     * An object that describes the cache behavior settings of the distribution. Detailed below
     * The following arguments are optional:
     */
    public val cacheBehaviorSettings: Output<DistributionCacheBehaviorSettings>?
        get() = javaResource.cacheBehaviorSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> distributionCacheBehaviorSettingsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A set of configuration blocks that describe the per-path cache behavior of the distribution. Detailed below
     */
    public val cacheBehaviors: Output<List<DistributionCacheBehavior>>?
        get() = javaResource.cacheBehaviors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        distributionCacheBehaviorToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The name of the SSL/TLS certificate attached to the distribution, if any.
     */
    public val certificateName: Output<String>?
        get() = javaResource.certificateName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The timestamp when the distribution was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Object that describes the default cache behavior of the distribution. Detailed below
     */
    public val defaultCacheBehavior: Output<DistributionDefaultCacheBehavior>
        get() = javaResource.defaultCacheBehavior().applyValue({ args0 ->
            args0.let({ args0 ->
                distributionDefaultCacheBehaviorToKotlin(args0)
            })
        })

    /**
     * The domain name of the distribution.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * The IP address type of the distribution. Default: `dualstack`.
     */
    public val ipAddressType: Output<String>?
        get() = javaResource.ipAddressType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the distribution is enabled. Default: `true`.
     */
    public val isEnabled: Output<Boolean>?
        get() = javaResource.isEnabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * An object that describes the location of the distribution, such as the AWS Region and Availability Zone. Detailed below
     */
    public val locations: Output<List<DistributionLocation>>
        get() = javaResource.locations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    distributionLocationToKotlin(args0)
                })
            })
        })

    /**
     * Name of the distribution.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Object that describes the origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer. Detailed below
     */
    public val origin: Output<DistributionOrigin>
        get() = javaResource.origin().applyValue({ args0 ->
            args0.let({ args0 ->
                distributionOriginToKotlin(args0)
            })
        })

    /**
     * The public DNS of the origin.
     */
    public val originPublicDns: Output<String>
        get() = javaResource.originPublicDns().applyValue({ args0 -> args0 })

    /**
     * The resource type of the origin resource (e.g., Instance).
     */
    public val resourceType: Output<String>
        get() = javaResource.resourceType().applyValue({ args0 -> args0 })

    /**
     * The status of the distribution.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The support code. Include this code in your email to support when you have questions about your Lightsail distribution. This code enables our support team to look up your Lightsail information more easily.
     */
    public val supportCode: Output<String>
        get() = javaResource.supportCode().applyValue({ args0 -> args0 })

    /**
     * Map of tags for the Lightsail Distribution. If
     * configured with a provider
     * `default_tags` configuration block
     * present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object DistributionMapper : ResourceMapper<Distribution> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.Distribution::class == javaResource::class

    override fun map(javaResource: Resource): Distribution = Distribution(
        javaResource as
            com.pulumi.aws.lightsail.Distribution,
    )
}

/**
 * @see [Distribution].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Distribution].
 */
public suspend fun distribution(
    name: String,
    block: suspend DistributionResourceBuilder.() -> Unit,
): Distribution {
    val builder = DistributionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Distribution].
 * @param name The _unique_ name of the resulting resource.
 */
public fun distribution(name: String): Distribution {
    val builder = DistributionResourceBuilder()
    builder.name(name)
    return builder.build()
}
