@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.DistributionArgs.builder
import com.pulumi.aws.lightsail.kotlin.inputs.DistributionCacheBehaviorArgs
import com.pulumi.aws.lightsail.kotlin.inputs.DistributionCacheBehaviorArgsBuilder
import com.pulumi.aws.lightsail.kotlin.inputs.DistributionCacheBehaviorSettingsArgs
import com.pulumi.aws.lightsail.kotlin.inputs.DistributionCacheBehaviorSettingsArgsBuilder
import com.pulumi.aws.lightsail.kotlin.inputs.DistributionDefaultCacheBehaviorArgs
import com.pulumi.aws.lightsail.kotlin.inputs.DistributionDefaultCacheBehaviorArgsBuilder
import com.pulumi.aws.lightsail.kotlin.inputs.DistributionOriginArgs
import com.pulumi.aws.lightsail.kotlin.inputs.DistributionOriginArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Lightsail Distribution.
 * ## Example Usage
 * ### Basic Usage
 * Below is a basic example with a bucket as an origin.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Bucket;
 * import com.pulumi.aws.lightsail.BucketArgs;
 * import com.pulumi.aws.lightsail.Distribution;
 * import com.pulumi.aws.lightsail.DistributionArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionOriginArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionDefaultCacheBehaviorArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsForwardedCookiesArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsForwardedHeadersArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsForwardedQueryStringsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testBucket = new Bucket("testBucket", BucketArgs.builder()
 *             .bundleId("small_1_0")
 *             .build());
 *         var testDistribution = new Distribution("testDistribution", DistributionArgs.builder()
 *             .bundleId("small_1_0")
 *             .origin(DistributionOriginArgs.builder()
 *                 .name(testBucket.name())
 *                 .regionName(testBucket.region())
 *                 .build())
 *             .defaultCacheBehavior(DistributionDefaultCacheBehaviorArgs.builder()
 *                 .behavior("cache")
 *                 .build())
 *             .cacheBehaviorSettings(DistributionCacheBehaviorSettingsArgs.builder()
 *                 .allowedHttpMethods("GET,HEAD,OPTIONS,PUT,PATCH,POST,DELETE")
 *                 .cachedHttpMethods("GET,HEAD")
 *                 .defaultTtl(86400)
 *                 .maximumTtl(31536000)
 *                 .minimumTtl(0)
 *                 .forwardedCookies(DistributionCacheBehaviorSettingsForwardedCookiesArgs.builder()
 *                     .option("none")
 *                     .build())
 *                 .forwardedHeaders(DistributionCacheBehaviorSettingsForwardedHeadersArgs.builder()
 *                     .option("default")
 *                     .build())
 *                 .forwardedQueryStrings(DistributionCacheBehaviorSettingsForwardedQueryStringsArgs.builder()
 *                     .option(false)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### instance origin example
 * Below is an example of an instance as the origin.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.lightsail.StaticIp;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.StaticIpAttachment;
 * import com.pulumi.aws.lightsail.StaticIpAttachmentArgs;
 * import com.pulumi.aws.lightsail.Distribution;
 * import com.pulumi.aws.lightsail.DistributionArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionOriginArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionDefaultCacheBehaviorArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .filters(GetAvailabilityZonesFilterArgs.builder()
 *                 .name("opt-in-status")
 *                 .values("opt-in-not-required")
 *                 .build())
 *             .build());
 *         var testStaticIp = new StaticIp("testStaticIp");
 *         var testInstance = new Instance("testInstance", InstanceArgs.builder()
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("micro_1_0")
 *             .build());
 *         var testStaticIpAttachment = new StaticIpAttachment("testStaticIpAttachment", StaticIpAttachmentArgs.builder()
 *             .staticIpName(testStaticIp.name())
 *             .instanceName(testInstance.name())
 *             .build());
 *         var testDistribution = new Distribution("testDistribution", DistributionArgs.builder()
 *             .bundleId("small_1_0")
 *             .origin(DistributionOriginArgs.builder()
 *                 .name(testInstance.name())
 *                 .regionName(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.id()))
 *                 .build())
 *             .defaultCacheBehavior(DistributionDefaultCacheBehaviorArgs.builder()
 *                 .behavior("cache")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(testStaticIpAttachment)
 *                 .build());
 *     }
 * }
 * ```
 * ### lb origin example
 * Below is an example with a load balancer as an origin
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.lightsail.Lb;
 * import com.pulumi.aws.lightsail.LbArgs;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.LbAttachment;
 * import com.pulumi.aws.lightsail.LbAttachmentArgs;
 * import com.pulumi.aws.lightsail.Distribution;
 * import com.pulumi.aws.lightsail.DistributionArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionOriginArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionDefaultCacheBehaviorArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .filters(GetAvailabilityZonesFilterArgs.builder()
 *                 .name("opt-in-status")
 *                 .values("opt-in-not-required")
 *                 .build())
 *             .build());
 *         var testLb = new Lb("testLb", LbArgs.builder()
 *             .healthCheckPath("/")
 *             .instancePort("80")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *         var testInstance = new Instance("testInstance", InstanceArgs.builder()
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_1_0")
 *             .build());
 *         var testLbAttachment = new LbAttachment("testLbAttachment", LbAttachmentArgs.builder()
 *             .lbName(testLb.name())
 *             .instanceName(testInstance.name())
 *             .build());
 *         var testDistribution = new Distribution("testDistribution", DistributionArgs.builder()
 *             .bundleId("small_1_0")
 *             .origin(DistributionOriginArgs.builder()
 *                 .name(testLb.name())
 *                 .regionName(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.id()))
 *                 .build())
 *             .defaultCacheBehavior(DistributionDefaultCacheBehaviorArgs.builder()
 *                 .behavior("cache")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(testLbAttachment)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Lightsail Distribution using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/distribution:Distribution example rft-8012925589
 * ```
 * @property bundleId Bundle ID to use for the distribution.
 * @property cacheBehaviorSettings An object that describes the cache behavior settings of the distribution. Detailed below
 * The following arguments are optional:
 * @property cacheBehaviors A set of configuration blocks that describe the per-path cache behavior of the distribution. Detailed below
 * @property certificateName The name of the SSL/TLS certificate attached to the distribution, if any.
 * @property defaultCacheBehavior Object that describes the default cache behavior of the distribution. Detailed below
 * @property ipAddressType The IP address type of the distribution. Default: `dualstack`.
 * @property isEnabled Indicates whether the distribution is enabled. Default: `true`.
 * @property name Name of the distribution.
 * @property origin Object that describes the origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer. Detailed below
 * @property tags Map of tags for the Lightsail Distribution. If
 * configured with a provider
 * `default_tags` configuration block
 * present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class DistributionArgs(
    public val bundleId: Output<String>? = null,
    public val cacheBehaviorSettings: Output<DistributionCacheBehaviorSettingsArgs>? = null,
    public val cacheBehaviors: Output<List<DistributionCacheBehaviorArgs>>? = null,
    public val certificateName: Output<String>? = null,
    public val defaultCacheBehavior: Output<DistributionDefaultCacheBehaviorArgs>? = null,
    public val ipAddressType: Output<String>? = null,
    public val isEnabled: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val origin: Output<DistributionOriginArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.DistributionArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.DistributionArgs =
        com.pulumi.aws.lightsail.DistributionArgs.builder()
            .bundleId(bundleId?.applyValue({ args0 -> args0 }))
            .cacheBehaviorSettings(
                cacheBehaviorSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .cacheBehaviors(
                cacheBehaviors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .certificateName(certificateName?.applyValue({ args0 -> args0 }))
            .defaultCacheBehavior(
                defaultCacheBehavior?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .ipAddressType(ipAddressType?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .origin(origin?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DistributionArgs].
 */
@PulumiTagMarker
public class DistributionArgsBuilder internal constructor() {
    private var bundleId: Output<String>? = null

    private var cacheBehaviorSettings: Output<DistributionCacheBehaviorSettingsArgs>? = null

    private var cacheBehaviors: Output<List<DistributionCacheBehaviorArgs>>? = null

    private var certificateName: Output<String>? = null

    private var defaultCacheBehavior: Output<DistributionDefaultCacheBehaviorArgs>? = null

    private var ipAddressType: Output<String>? = null

    private var isEnabled: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var origin: Output<DistributionOriginArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Bundle ID to use for the distribution.
     */
    @JvmName("mopbwykyvwhvntqs")
    public suspend fun bundleId(`value`: Output<String>) {
        this.bundleId = value
    }

    /**
     * @param value An object that describes the cache behavior settings of the distribution. Detailed below
     * The following arguments are optional:
     */
    @JvmName("phvlkkhtnfkxyfov")
    public suspend fun cacheBehaviorSettings(`value`: Output<DistributionCacheBehaviorSettingsArgs>) {
        this.cacheBehaviorSettings = value
    }

    /**
     * @param value A set of configuration blocks that describe the per-path cache behavior of the distribution. Detailed below
     */
    @JvmName("tpbbgklqtddnemsf")
    public suspend fun cacheBehaviors(`value`: Output<List<DistributionCacheBehaviorArgs>>) {
        this.cacheBehaviors = value
    }

    @JvmName("tkpgqxfkrqykioxn")
    public suspend fun cacheBehaviors(vararg values: Output<DistributionCacheBehaviorArgs>) {
        this.cacheBehaviors = Output.all(values.asList())
    }

    /**
     * @param values A set of configuration blocks that describe the per-path cache behavior of the distribution. Detailed below
     */
    @JvmName("jpavwvgmtrnfldxv")
    public suspend fun cacheBehaviors(values: List<Output<DistributionCacheBehaviorArgs>>) {
        this.cacheBehaviors = Output.all(values)
    }

    /**
     * @param value The name of the SSL/TLS certificate attached to the distribution, if any.
     */
    @JvmName("nriqjouggphkdncd")
    public suspend fun certificateName(`value`: Output<String>) {
        this.certificateName = value
    }

    /**
     * @param value Object that describes the default cache behavior of the distribution. Detailed below
     */
    @JvmName("lxdkivkgrnahasyl")
    public suspend fun defaultCacheBehavior(`value`: Output<DistributionDefaultCacheBehaviorArgs>) {
        this.defaultCacheBehavior = value
    }

    /**
     * @param value The IP address type of the distribution. Default: `dualstack`.
     */
    @JvmName("xpknphuunnrensub")
    public suspend fun ipAddressType(`value`: Output<String>) {
        this.ipAddressType = value
    }

    /**
     * @param value Indicates whether the distribution is enabled. Default: `true`.
     */
    @JvmName("omlkfguvtxmnxcjc")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value Name of the distribution.
     */
    @JvmName("tqsihiytployvpaj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Object that describes the origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer. Detailed below
     */
    @JvmName("oxlvplmotcrdrfdp")
    public suspend fun origin(`value`: Output<DistributionOriginArgs>) {
        this.origin = value
    }

    /**
     * @param value Map of tags for the Lightsail Distribution. If
     * configured with a provider
     * `default_tags` configuration block
     * present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cryuktffumccnxhk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Bundle ID to use for the distribution.
     */
    @JvmName("uawcpyuepjftrprk")
    public suspend fun bundleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bundleId = mapped
    }

    /**
     * @param value An object that describes the cache behavior settings of the distribution. Detailed below
     * The following arguments are optional:
     */
    @JvmName("ivkkasnclavnedoc")
    public suspend fun cacheBehaviorSettings(`value`: DistributionCacheBehaviorSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheBehaviorSettings = mapped
    }

    /**
     * @param argument An object that describes the cache behavior settings of the distribution. Detailed below
     * The following arguments are optional:
     */
    @JvmName("uahapjkoranydsym")
    public suspend
    fun cacheBehaviorSettings(argument: suspend DistributionCacheBehaviorSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DistributionCacheBehaviorSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cacheBehaviorSettings = mapped
    }

    /**
     * @param value A set of configuration blocks that describe the per-path cache behavior of the distribution. Detailed below
     */
    @JvmName("avnkvyvjviisoghp")
    public suspend fun cacheBehaviors(`value`: List<DistributionCacheBehaviorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheBehaviors = mapped
    }

    /**
     * @param argument A set of configuration blocks that describe the per-path cache behavior of the distribution. Detailed below
     */
    @JvmName("qjxffxppatemprem")
    public suspend
    fun cacheBehaviors(argument: List<suspend DistributionCacheBehaviorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DistributionCacheBehaviorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.cacheBehaviors = mapped
    }

    /**
     * @param argument A set of configuration blocks that describe the per-path cache behavior of the distribution. Detailed below
     */
    @JvmName("pkhpnkokxenbqveq")
    public suspend fun cacheBehaviors(
        vararg
        argument: suspend DistributionCacheBehaviorArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DistributionCacheBehaviorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.cacheBehaviors = mapped
    }

    /**
     * @param argument A set of configuration blocks that describe the per-path cache behavior of the distribution. Detailed below
     */
    @JvmName("exulccjtnqykcxvc")
    public suspend
    fun cacheBehaviors(argument: suspend DistributionCacheBehaviorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DistributionCacheBehaviorArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.cacheBehaviors = mapped
    }

    /**
     * @param values A set of configuration blocks that describe the per-path cache behavior of the distribution. Detailed below
     */
    @JvmName("nbeefchsxcjvvxrb")
    public suspend fun cacheBehaviors(vararg values: DistributionCacheBehaviorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cacheBehaviors = mapped
    }

    /**
     * @param value The name of the SSL/TLS certificate attached to the distribution, if any.
     */
    @JvmName("hfckeumcrevnttkb")
    public suspend fun certificateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateName = mapped
    }

    /**
     * @param value Object that describes the default cache behavior of the distribution. Detailed below
     */
    @JvmName("qiubgejwfumwjjxc")
    public suspend fun defaultCacheBehavior(`value`: DistributionDefaultCacheBehaviorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultCacheBehavior = mapped
    }

    /**
     * @param argument Object that describes the default cache behavior of the distribution. Detailed below
     */
    @JvmName("bxrktirhiuwhjcde")
    public suspend
    fun defaultCacheBehavior(argument: suspend DistributionDefaultCacheBehaviorArgsBuilder.() -> Unit) {
        val toBeMapped = DistributionDefaultCacheBehaviorArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.defaultCacheBehavior = mapped
    }

    /**
     * @param value The IP address type of the distribution. Default: `dualstack`.
     */
    @JvmName("mhijsobtgrahsjtt")
    public suspend fun ipAddressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddressType = mapped
    }

    /**
     * @param value Indicates whether the distribution is enabled. Default: `true`.
     */
    @JvmName("kvijeaoknoqlpcng")
    public suspend fun isEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value Name of the distribution.
     */
    @JvmName("bufsfccfpdslvply")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Object that describes the origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer. Detailed below
     */
    @JvmName("lldypfnqfhaeuitl")
    public suspend fun origin(`value`: DistributionOriginArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.origin = mapped
    }

    /**
     * @param argument Object that describes the origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer. Detailed below
     */
    @JvmName("rjeimuwgkkbbftmx")
    public suspend fun origin(argument: suspend DistributionOriginArgsBuilder.() -> Unit) {
        val toBeMapped = DistributionOriginArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.origin = mapped
    }

    /**
     * @param value Map of tags for the Lightsail Distribution. If
     * configured with a provider
     * `default_tags` configuration block
     * present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fhhfqernqejbwuwd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags for the Lightsail Distribution. If
     * configured with a provider
     * `default_tags` configuration block
     * present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hjulobghdshlndsh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DistributionArgs = DistributionArgs(
        bundleId = bundleId,
        cacheBehaviorSettings = cacheBehaviorSettings,
        cacheBehaviors = cacheBehaviors,
        certificateName = certificateName,
        defaultCacheBehavior = defaultCacheBehavior,
        ipAddressType = ipAddressType,
        isEnabled = isEnabled,
        name = name,
        origin = origin,
        tags = tags,
    )
}
