@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.DomainArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creates a domain resource for the specified domain (e.g., example.com).
 * You cannot register a new domain name using Lightsail. You must register
 * a domain name using Amazon Route 53 or another domain name registrar.
 * If you have already registered your domain, you can enter its name in
 * this parameter to manage the DNS records for that domain.
 * > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Domain;
 * import com.pulumi.aws.lightsail.DomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var domainTest = new Domain("domainTest", DomainArgs.builder()
 *             .domainName("mydomain.com")
 *             .build());
 *     }
 * }
 * ```
 * @property domainName The name of the Lightsail domain to manage
 */
public data class DomainArgs(
    public val domainName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.DomainArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.DomainArgs =
        com.pulumi.aws.lightsail.DomainArgs.builder()
            .domainName(domainName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainArgs].
 */
@PulumiTagMarker
public class DomainArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    /**
     * @param value The name of the Lightsail domain to manage
     */
    @JvmName("cpwidaiekgltmtbm")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The name of the Lightsail domain to manage
     */
    @JvmName("eluctnctutxnfpob")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    internal fun build(): DomainArgs = DomainArgs(
        domainName = domainName,
    )
}
