@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DomainEntry].
 */
@PulumiTagMarker
public class DomainEntryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainEntryArgs = DomainEntryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainEntryArgsBuilder.() -> Unit) {
        val builder = DomainEntryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DomainEntry {
        val builtJavaResource = com.pulumi.aws.lightsail.DomainEntry(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainEntry(builtJavaResource)
    }
}

/**
 * Creates a domain entry resource
 * > **NOTE on `id`:** In an effort to simplify imports, this resource `id` field has been updated to the standard resource id separator, a comma (`,`). For backward compatibility, the previous separator (underscore `_`) can still be used to read and import existing resources. When state is refreshed, the `id` will be updated to use the new standard separator. The previous separator will be deprecated in a future major release.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Domain;
 * import com.pulumi.aws.lightsail.DomainArgs;
 * import com.pulumi.aws.lightsail.DomainEntry;
 * import com.pulumi.aws.lightsail.DomainEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testDomain = new Domain("testDomain", DomainArgs.builder()
 *             .domainName("mydomain.com")
 *             .build());
 *         var testDomainEntry = new DomainEntry("testDomainEntry", DomainEntryArgs.builder()
 *             .domainName(aws_lightsail_domain.domain_test().domain_name())
 *             .type("A")
 *             .target("127.0.0.1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_domain_entry` using the id attribute. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/domainEntry:DomainEntry example www,mydomain.com,A,127.0.0.1
 * ```
 *
 */
public class DomainEntry internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.DomainEntry,
) : KotlinCustomResource(javaResource, DomainEntryMapper) {
    /**
     * The name of the Lightsail domain in which to create the entry
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * If the entry should be an alias Defaults to `false`
     */
    public val isAlias: Output<Boolean>?
        get() = javaResource.isAlias().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the entry record
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Target of the domain entry
     */
    public val target: Output<String>
        get() = javaResource.target().applyValue({ args0 -> args0 })

    /**
     * Type of record
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DomainEntryMapper : ResourceMapper<DomainEntry> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.DomainEntry::class == javaResource::class

    override fun map(javaResource: Resource): DomainEntry = DomainEntry(
        javaResource as
            com.pulumi.aws.lightsail.DomainEntry,
    )
}

/**
 * @see [DomainEntry].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainEntry].
 */
public suspend fun domainEntry(name: String, block: suspend DomainEntryResourceBuilder.() -> Unit):
    DomainEntry {
    val builder = DomainEntryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainEntry].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainEntry(name: String): DomainEntry {
    val builder = DomainEntryResourceBuilder()
    builder.name(name)
    return builder.build()
}
