@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.kotlin.outputs.InstanceAddOn
import com.pulumi.aws.lightsail.kotlin.outputs.InstanceAddOn.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.aws.lightsail.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 * Provides a Lightsail Instance. Amazon Lightsail is a service to provide easy virtual private servers
 * with custom software already setup. See [What is Amazon Lightsail?](https://lightsail.aws.amazon.com/ls/docs/getting-started/article/what-is-amazon-lightsail)
 * for more information.
 * > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gitlabTest = new Instance("gitlabTest", InstanceArgs.builder()
 *             .availabilityZone("us-east-1b")
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_1_0")
 *             .keyPairName("some_key_name")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *     }
 * }
 * ```
 * ### Example With User Data
 * Lightsail user data is handled differently than ec2 user data. Lightsail user data only accepts a single lined string. The below example shows installing apache and creating the index page.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var custom = new Instance("custom", InstanceArgs.builder()
 *             .availabilityZone("us-east-1b")
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_1_0")
 *             .userData("sudo yum install -y httpd && sudo systemctl start httpd && sudo systemctl enable httpd && echo '<h1>Deployed via Pulumi</h1>' | sudo tee /var/www/html/index.html")
 *             .build());
 *     }
 * }
 * ```
 * ### Enable Auto Snapshots
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.inputs.InstanceAddOnArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Instance("test", InstanceArgs.builder()
 *             .addOn(InstanceAddOnArgs.builder()
 *                 .snapshotTime("06:00")
 *                 .status("Enabled")
 *                 .type("AutoSnapshot")
 *                 .build())
 *             .availabilityZone("us-east-1b")
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_1_0")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *     }
 * }
 * ```
 * ## Availability Zones
 * Lightsail currently supports the following Availability Zones (e.g., `us-east-1a`):
 * - `ap-northeast-1{a,c,d}`
 * - `ap-northeast-2{a,c}`
 * - `ap-south-1{a,b}`
 * - `ap-southeast-1{a,b,c}`
 * - `ap-southeast-2{a,b,c}`
 * - `ca-central-1{a,b}`
 * - `eu-central-1{a,b,c}`
 * - `eu-west-1{a,b,c}`
 * - `eu-west-2{a,b,c}`
 * - `eu-west-3{a,b,c}`
 * - `us-east-1{a,b,c,d,e,f}`
 * - `us-east-2{a,b,c}`
 * - `us-west-2{a,b,c}`
 * ## Bundles
 * Lightsail currently supports the following Bundle IDs (e.g., an instance in `ap-northeast-1` would use `small_2_0`):
 * ### Prefix
 * A Bundle ID starts with one of the below size prefixes:
 * - `nano_`
 * - `micro_`
 * - `small_`
 * - `medium_`
 * - `large_`
 * - `xlarge_`
 * - `2xlarge_`
 * ### Suffix
 * A Bundle ID ends with one of the following suffixes depending on Availability Zone:
 * - ap-northeast-1: `2_0`
 * - ap-northeast-2: `2_0`
 * - ap-south-1: `2_1`
 * - ap-southeast-1: `2_0`
 * - ap-southeast-2: `2_2`
 * - ca-central-1: `2_0`
 * - eu-central-1: `2_0`
 * - eu-west-1: `2_0`
 * - eu-west-2: `2_0`
 * - eu-west-3: `2_0`
 * - us-east-1: `2_0`
 * - us-east-2: `2_0`
 * - us-west-2: `2_0`
 * ## Import
 * Using `pulumi import`, import Lightsail Instances using their name. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/instance:Instance gitlab_test 'custom_gitlab'
 * ```
 *
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * The add on configuration for the instance. Detailed below.
     */
    public val addOn: Output<InstanceAddOn>?
        get() = javaResource.addOn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The ARN of the Lightsail instance (matches `id`).
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Availability Zone in which to create your
     * instance (see list below)
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * The ID for a virtual private server image. A list of available blueprint IDs can be obtained using the AWS CLI command: `aws lightsail get-blueprints`
     */
    public val blueprintId: Output<String>
        get() = javaResource.blueprintId().applyValue({ args0 -> args0 })

    /**
     * The bundle of specification information (see list below)
     */
    public val bundleId: Output<String>
        get() = javaResource.bundleId().applyValue({ args0 -> args0 })

    /**
     * The number of vCPUs the instance has.
     */
    public val cpuCount: Output<Int>
        get() = javaResource.cpuCount().applyValue({ args0 -> args0 })

    /**
     * The timestamp when the instance was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The IP address type of the Lightsail Instance. Valid Values: `dualstack` | `ipv4`.
     */
    public val ipAddressType: Output<String>?
        get() = javaResource.ipAddressType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of IPv6 addresses for the Lightsail instance.
     */
    public val ipv6Addresses: Output<List<String>>
        get() = javaResource.ipv6Addresses().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A Boolean value indicating whether this instance has a static IP assigned to it.
     */
    public val isStaticIp: Output<Boolean>
        get() = javaResource.isStaticIp().applyValue({ args0 -> args0 })

    /**
     * The name of your key pair. Created in the
     * Lightsail console (cannot use `aws.ec2.KeyPair` at this time)
     */
    public val keyPairName: Output<String>?
        get() = javaResource.keyPairName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the Lightsail Instance. Names be unique within each AWS Region in your Lightsail account.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The private IP address of the instance.
     */
    public val privateIpAddress: Output<String>
        get() = javaResource.privateIpAddress().applyValue({ args0 -> args0 })

    /**
     * The public IP address of the instance.
     */
    public val publicIpAddress: Output<String>
        get() = javaResource.publicIpAddress().applyValue({ args0 -> args0 })

    /**
     * The amount of RAM in GB on the instance (e.g., 1.0).
     */
    public val ramSize: Output<Double>
        get() = javaResource.ramSize().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Single lined launch script as a string to configure server with additional user data
     */
    public val userData: Output<String>?
        get() = javaResource.userData().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The user name for connecting to the instance (e.g., ec2-user).
     */
    public val username: Output<String>
        get() = javaResource.username().applyValue({ args0 -> args0 })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.aws.lightsail.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit):
    Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
