@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.InstanceArgs.builder
import com.pulumi.aws.lightsail.kotlin.inputs.InstanceAddOnArgs
import com.pulumi.aws.lightsail.kotlin.inputs.InstanceAddOnArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Lightsail Instance. Amazon Lightsail is a service to provide easy virtual private servers
 * with custom software already setup. See [What is Amazon Lightsail?](https://lightsail.aws.amazon.com/ls/docs/getting-started/article/what-is-amazon-lightsail)
 * for more information.
 * > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gitlabTest = new Instance("gitlabTest", InstanceArgs.builder()
 *             .availabilityZone("us-east-1b")
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_1_0")
 *             .keyPairName("some_key_name")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *     }
 * }
 * ```
 * ### Example With User Data
 * Lightsail user data is handled differently than ec2 user data. Lightsail user data only accepts a single lined string. The below example shows installing apache and creating the index page.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var custom = new Instance("custom", InstanceArgs.builder()
 *             .availabilityZone("us-east-1b")
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_1_0")
 *             .userData("sudo yum install -y httpd && sudo systemctl start httpd && sudo systemctl enable httpd && echo '<h1>Deployed via Pulumi</h1>' | sudo tee /var/www/html/index.html")
 *             .build());
 *     }
 * }
 * ```
 * ### Enable Auto Snapshots
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.inputs.InstanceAddOnArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Instance("test", InstanceArgs.builder()
 *             .addOn(InstanceAddOnArgs.builder()
 *                 .snapshotTime("06:00")
 *                 .status("Enabled")
 *                 .type("AutoSnapshot")
 *                 .build())
 *             .availabilityZone("us-east-1b")
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_1_0")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *     }
 * }
 * ```
 * ## Availability Zones
 * Lightsail currently supports the following Availability Zones (e.g., `us-east-1a`):
 * - `ap-northeast-1{a,c,d}`
 * - `ap-northeast-2{a,c}`
 * - `ap-south-1{a,b}`
 * - `ap-southeast-1{a,b,c}`
 * - `ap-southeast-2{a,b,c}`
 * - `ca-central-1{a,b}`
 * - `eu-central-1{a,b,c}`
 * - `eu-west-1{a,b,c}`
 * - `eu-west-2{a,b,c}`
 * - `eu-west-3{a,b,c}`
 * - `us-east-1{a,b,c,d,e,f}`
 * - `us-east-2{a,b,c}`
 * - `us-west-2{a,b,c}`
 * ## Bundles
 * Lightsail currently supports the following Bundle IDs (e.g., an instance in `ap-northeast-1` would use `small_2_0`):
 * ### Prefix
 * A Bundle ID starts with one of the below size prefixes:
 * - `nano_`
 * - `micro_`
 * - `small_`
 * - `medium_`
 * - `large_`
 * - `xlarge_`
 * - `2xlarge_`
 * ### Suffix
 * A Bundle ID ends with one of the following suffixes depending on Availability Zone:
 * - ap-northeast-1: `2_0`
 * - ap-northeast-2: `2_0`
 * - ap-south-1: `2_1`
 * - ap-southeast-1: `2_0`
 * - ap-southeast-2: `2_2`
 * - ca-central-1: `2_0`
 * - eu-central-1: `2_0`
 * - eu-west-1: `2_0`
 * - eu-west-2: `2_0`
 * - eu-west-3: `2_0`
 * - us-east-1: `2_0`
 * - us-east-2: `2_0`
 * - us-west-2: `2_0`
 * ## Import
 * Using `pulumi import`, import Lightsail Instances using their name. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/instance:Instance gitlab_test 'custom_gitlab'
 * ```
 * @property addOn The add on configuration for the instance. Detailed below.
 * @property availabilityZone The Availability Zone in which to create your
 * instance (see list below)
 * @property blueprintId The ID for a virtual private server image. A list of available blueprint IDs can be obtained using the AWS CLI command: `aws lightsail get-blueprints`
 * @property bundleId The bundle of specification information (see list below)
 * @property ipAddressType The IP address type of the Lightsail Instance. Valid Values: `dualstack` | `ipv4`.
 * @property keyPairName The name of your key pair. Created in the
 * Lightsail console (cannot use `aws.ec2.KeyPair` at this time)
 * @property name The name of the Lightsail Instance. Names be unique within each AWS Region in your Lightsail account.
 * @property tags A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property userData Single lined launch script as a string to configure server with additional user data
 */
public data class InstanceArgs(
    public val addOn: Output<InstanceAddOnArgs>? = null,
    public val availabilityZone: Output<String>? = null,
    public val blueprintId: Output<String>? = null,
    public val bundleId: Output<String>? = null,
    public val ipAddressType: Output<String>? = null,
    public val keyPairName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userData: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.InstanceArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.InstanceArgs =
        com.pulumi.aws.lightsail.InstanceArgs.builder()
            .addOn(addOn?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .blueprintId(blueprintId?.applyValue({ args0 -> args0 }))
            .bundleId(bundleId?.applyValue({ args0 -> args0 }))
            .ipAddressType(ipAddressType?.applyValue({ args0 -> args0 }))
            .keyPairName(keyPairName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userData(userData?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var addOn: Output<InstanceAddOnArgs>? = null

    private var availabilityZone: Output<String>? = null

    private var blueprintId: Output<String>? = null

    private var bundleId: Output<String>? = null

    private var ipAddressType: Output<String>? = null

    private var keyPairName: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userData: Output<String>? = null

    /**
     * @param value The add on configuration for the instance. Detailed below.
     */
    @JvmName("gqpxyvrufsmpfytp")
    public suspend fun addOn(`value`: Output<InstanceAddOnArgs>) {
        this.addOn = value
    }

    /**
     * @param value The Availability Zone in which to create your
     * instance (see list below)
     */
    @JvmName("lwkcotkyniuljlso")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value The ID for a virtual private server image. A list of available blueprint IDs can be obtained using the AWS CLI command: `aws lightsail get-blueprints`
     */
    @JvmName("gdnsfdhhbyrcdcgj")
    public suspend fun blueprintId(`value`: Output<String>) {
        this.blueprintId = value
    }

    /**
     * @param value The bundle of specification information (see list below)
     */
    @JvmName("wtkurgoockiwhqup")
    public suspend fun bundleId(`value`: Output<String>) {
        this.bundleId = value
    }

    /**
     * @param value The IP address type of the Lightsail Instance. Valid Values: `dualstack` | `ipv4`.
     */
    @JvmName("ryijkgrdldywugod")
    public suspend fun ipAddressType(`value`: Output<String>) {
        this.ipAddressType = value
    }

    /**
     * @param value The name of your key pair. Created in the
     * Lightsail console (cannot use `aws.ec2.KeyPair` at this time)
     */
    @JvmName("hiknfaoqrrvaprvb")
    public suspend fun keyPairName(`value`: Output<String>) {
        this.keyPairName = value
    }

    /**
     * @param value The name of the Lightsail Instance. Names be unique within each AWS Region in your Lightsail account.
     */
    @JvmName("xhmhmewhvgnvogak")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gsypxeglnccltixu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Single lined launch script as a string to configure server with additional user data
     */
    @JvmName("myuhhxvtshfxuidy")
    public suspend fun userData(`value`: Output<String>) {
        this.userData = value
    }

    /**
     * @param value The add on configuration for the instance. Detailed below.
     */
    @JvmName("wewptprigcuhggva")
    public suspend fun addOn(`value`: InstanceAddOnArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addOn = mapped
    }

    /**
     * @param argument The add on configuration for the instance. Detailed below.
     */
    @JvmName("augpvhixvqqenchs")
    public suspend fun addOn(argument: suspend InstanceAddOnArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceAddOnArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.addOn = mapped
    }

    /**
     * @param value The Availability Zone in which to create your
     * instance (see list below)
     */
    @JvmName("iqqyavrcrprryeod")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value The ID for a virtual private server image. A list of available blueprint IDs can be obtained using the AWS CLI command: `aws lightsail get-blueprints`
     */
    @JvmName("ktvwgtcygvpukbjy")
    public suspend fun blueprintId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blueprintId = mapped
    }

    /**
     * @param value The bundle of specification information (see list below)
     */
    @JvmName("tmpuhfoelkkjoocy")
    public suspend fun bundleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bundleId = mapped
    }

    /**
     * @param value The IP address type of the Lightsail Instance. Valid Values: `dualstack` | `ipv4`.
     */
    @JvmName("kudjmiyqaqqwndxq")
    public suspend fun ipAddressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddressType = mapped
    }

    /**
     * @param value The name of your key pair. Created in the
     * Lightsail console (cannot use `aws.ec2.KeyPair` at this time)
     */
    @JvmName("trkndpanwafxnnqx")
    public suspend fun keyPairName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPairName = mapped
    }

    /**
     * @param value The name of the Lightsail Instance. Names be unique within each AWS Region in your Lightsail account.
     */
    @JvmName("gjktomnneugmhdso")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("boieeoucxgkbqdgw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xsmdjrysqqomrvgt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Single lined launch script as a string to configure server with additional user data
     */
    @JvmName("kmrjwtcycoolhubg")
    public suspend fun userData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userData = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        addOn = addOn,
        availabilityZone = availabilityZone,
        blueprintId = blueprintId,
        bundleId = bundleId,
        ipAddressType = ipAddressType,
        keyPairName = keyPairName,
        name = name,
        tags = tags,
        userData = userData,
    )
}
