@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.kotlin.outputs.InstancePublicPortsPortInfo
import com.pulumi.aws.lightsail.kotlin.outputs.InstancePublicPortsPortInfo.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [InstancePublicPorts].
 */
@PulumiTagMarker
public class InstancePublicPortsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstancePublicPortsArgs = InstancePublicPortsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstancePublicPortsArgsBuilder.() -> Unit) {
        val builder = InstancePublicPortsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): InstancePublicPorts {
        val builtJavaResource = com.pulumi.aws.lightsail.InstancePublicPorts(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InstancePublicPorts(builtJavaResource)
    }
}

/**
 * Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the instance through the ports, and the protocol.
 * > See [What is Amazon Lightsail?](https://lightsail.aws.amazon.com/ls/docs/getting-started/article/what-is-amazon-lightsail) for more information.
 * > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.InstancePublicPorts;
 * import com.pulumi.aws.lightsail.InstancePublicPortsArgs;
 * import com.pulumi.aws.lightsail.inputs.InstancePublicPortsPortInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testInstance = new Instance("testInstance", InstanceArgs.builder()
 *             .availabilityZone(data.aws_availability_zones().available().names()[0])
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_1_0")
 *             .build());
 *         var testInstancePublicPorts = new InstancePublicPorts("testInstancePublicPorts", InstancePublicPortsArgs.builder()
 *             .instanceName(testInstance.name())
 *             .portInfos(InstancePublicPortsPortInfoArgs.builder()
 *                 .protocol("tcp")
 *                 .fromPort(80)
 *                 .toPort(80)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 */
public class InstancePublicPorts internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.InstancePublicPorts,
) : KotlinCustomResource(javaResource, InstancePublicPortsMapper) {
    /**
     * Name of the Lightsail Instance.
     */
    public val instanceName: Output<String>
        get() = javaResource.instanceName().applyValue({ args0 -> args0 })

    /**
     * Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
     */
    public val portInfos: Output<List<InstancePublicPortsPortInfo>>
        get() = javaResource.portInfos().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })
}

public object InstancePublicPortsMapper : ResourceMapper<InstancePublicPorts> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.InstancePublicPorts::class == javaResource::class

    override fun map(javaResource: Resource): InstancePublicPorts = InstancePublicPorts(
        javaResource
            as com.pulumi.aws.lightsail.InstancePublicPorts,
    )
}

/**
 * @see [InstancePublicPorts].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InstancePublicPorts].
 */
public suspend fun instancePublicPorts(
    name: String,
    block: suspend InstancePublicPortsResourceBuilder.() -> Unit,
): InstancePublicPorts {
    val builder = InstancePublicPortsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InstancePublicPorts].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instancePublicPorts(name: String): InstancePublicPorts {
    val builder = InstancePublicPortsResourceBuilder()
    builder.name(name)
    return builder.build()
}
