@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.InstancePublicPortsArgs.builder
import com.pulumi.aws.lightsail.kotlin.inputs.InstancePublicPortsPortInfoArgs
import com.pulumi.aws.lightsail.kotlin.inputs.InstancePublicPortsPortInfoArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the instance through the ports, and the protocol.
 * > See [What is Amazon Lightsail?](https://lightsail.aws.amazon.com/ls/docs/getting-started/article/what-is-amazon-lightsail) for more information.
 * > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.InstancePublicPorts;
 * import com.pulumi.aws.lightsail.InstancePublicPortsArgs;
 * import com.pulumi.aws.lightsail.inputs.InstancePublicPortsPortInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testInstance = new Instance("testInstance", InstanceArgs.builder()
 *             .availabilityZone(data.aws_availability_zones().available().names()[0])
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_1_0")
 *             .build());
 *         var testInstancePublicPorts = new InstancePublicPorts("testInstancePublicPorts", InstancePublicPortsArgs.builder()
 *             .instanceName(testInstance.name())
 *             .portInfos(InstancePublicPortsPortInfoArgs.builder()
 *                 .protocol("tcp")
 *                 .fromPort(80)
 *                 .toPort(80)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * @property instanceName Name of the Lightsail Instance.
 * @property portInfos Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
 */
public data class InstancePublicPortsArgs(
    public val instanceName: Output<String>? = null,
    public val portInfos: Output<List<InstancePublicPortsPortInfoArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.InstancePublicPortsArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.InstancePublicPortsArgs =
        com.pulumi.aws.lightsail.InstancePublicPortsArgs.builder()
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .portInfos(
                portInfos?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [InstancePublicPortsArgs].
 */
@PulumiTagMarker
public class InstancePublicPortsArgsBuilder internal constructor() {
    private var instanceName: Output<String>? = null

    private var portInfos: Output<List<InstancePublicPortsPortInfoArgs>>? = null

    /**
     * @param value Name of the Lightsail Instance.
     */
    @JvmName("ftsqmkcbmbbagarc")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
     */
    @JvmName("spsbejyhsajrocbj")
    public suspend fun portInfos(`value`: Output<List<InstancePublicPortsPortInfoArgs>>) {
        this.portInfos = value
    }

    @JvmName("pewgpscublonuwlg")
    public suspend fun portInfos(vararg values: Output<InstancePublicPortsPortInfoArgs>) {
        this.portInfos = Output.all(values.asList())
    }

    /**
     * @param values Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
     */
    @JvmName("kdrsqfqynoikcrck")
    public suspend fun portInfos(values: List<Output<InstancePublicPortsPortInfoArgs>>) {
        this.portInfos = Output.all(values)
    }

    /**
     * @param value Name of the Lightsail Instance.
     */
    @JvmName("xhkrudtpwhfggclg")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
     */
    @JvmName("btdlkxnsutmpxfls")
    public suspend fun portInfos(`value`: List<InstancePublicPortsPortInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portInfos = mapped
    }

    /**
     * @param argument Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
     */
    @JvmName("ijqnorundqfkrdnk")
    public suspend
    fun portInfos(argument: List<suspend InstancePublicPortsPortInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstancePublicPortsPortInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.portInfos = mapped
    }

    /**
     * @param argument Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
     */
    @JvmName("hosnqumspmgoydye")
    public suspend fun portInfos(
        vararg
        argument: suspend InstancePublicPortsPortInfoArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            InstancePublicPortsPortInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.portInfos = mapped
    }

    /**
     * @param argument Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
     */
    @JvmName("dprwwynanvoiwlpc")
    public suspend
    fun portInfos(argument: suspend InstancePublicPortsPortInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InstancePublicPortsPortInfoArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.portInfos = mapped
    }

    /**
     * @param values Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
     */
    @JvmName("jkxinaajtqhxduuk")
    public suspend fun portInfos(vararg values: InstancePublicPortsPortInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portInfos = mapped
    }

    internal fun build(): InstancePublicPortsArgs = InstancePublicPortsArgs(
        instanceName = instanceName,
        portInfos = portInfos,
    )
}
