@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [KeyPair].
 */
@PulumiTagMarker
public class KeyPairResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KeyPairArgs = KeyPairArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KeyPairArgsBuilder.() -> Unit) {
        val builder = KeyPairArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): KeyPair {
        val builtJavaResource = com.pulumi.aws.lightsail.KeyPair(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KeyPair(builtJavaResource)
    }
}

/**
 * Provides a Lightsail Key Pair, for use with Lightsail Instances. These key pairs
 * are separate from EC2 Key Pairs, and must be created or imported for use with
 * Lightsail.
 * > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details
 * ## Example Usage
 * ### Create New Key Pair
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.KeyPair;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lgKeyPair = new KeyPair("lgKeyPair");
 *     }
 * }
 * ```
 * ### Create New Key Pair with PGP Encrypted Private Key
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.KeyPair;
 * import com.pulumi.aws.lightsail.KeyPairArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lgKeyPair = new KeyPair("lgKeyPair", KeyPairArgs.builder()
 *             .pgpKey("keybase:keybaseusername")
 *             .build());
 *     }
 * }
 * ```
 * ### Existing Public Key Import
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.KeyPair;
 * import com.pulumi.aws.lightsail.KeyPairArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lgKeyPair = new KeyPair("lgKeyPair", KeyPairArgs.builder()
 *             .publicKey(Files.readString(Paths.get("~/.ssh/id_rsa.pub")))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * You cannot import Lightsail Key Pairs because the private and public key are only available on initial creation.
 */
public class KeyPair internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.KeyPair,
) : KotlinCustomResource(javaResource, KeyPairMapper) {
    /**
     * The ARN of the Lightsail key pair.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The MD5 public key fingerprint for the encrypted private key.
     */
    public val encryptedFingerprint: Output<String>
        get() = javaResource.encryptedFingerprint().applyValue({ args0 -> args0 })

    /**
     * the private key material, base 64 encoded and encrypted with the given `pgp_key`. This is only populated when creating a new key and `pgp_key` is supplied.
     */
    public val encryptedPrivateKey: Output<String>
        get() = javaResource.encryptedPrivateKey().applyValue({ args0 -> args0 })

    /**
     * The MD5 public key fingerprint as specified in section 4 of RFC 4716.
     */
    public val fingerprint: Output<String>
        get() = javaResource.fingerprint().applyValue({ args0 -> args0 })

    /**
     * The name of the Lightsail Key Pair. If omitted, a unique name will be generated by this provider
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * An optional PGP key to encrypt the resulting private key material. Only used when creating a new key pair
     */
    public val pgpKey: Output<String>?
        get() = javaResource.pgpKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * the private key, base64 encoded. This is only populated when creating a new key, and when no `pgp_key` is provided.
     */
    public val privateKey: Output<String>
        get() = javaResource.privateKey().applyValue({ args0 -> args0 })

    /**
     * The public key material. This public key will be imported into Lightsail
     */
    public val publicKey: Output<String>
        get() = javaResource.publicKey().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * > **NOTE:** a PGP key is not required, however it is strongly encouraged. Without a PGP key, the private key material will be stored in state unencrypted.`pgp_key` is ignored if `public_key` is supplied.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object KeyPairMapper : ResourceMapper<KeyPair> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.KeyPair::class == javaResource::class

    override fun map(javaResource: Resource): KeyPair = KeyPair(
        javaResource as
            com.pulumi.aws.lightsail.KeyPair,
    )
}

/**
 * @see [KeyPair].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KeyPair].
 */
public suspend fun keyPair(name: String, block: suspend KeyPairResourceBuilder.() -> Unit):
    KeyPair {
    val builder = KeyPairResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KeyPair].
 * @param name The _unique_ name of the resulting resource.
 */
public fun keyPair(name: String): KeyPair {
    val builder = KeyPairResourceBuilder()
    builder.name(name)
    return builder.build()
}
