@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.KeyPairArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Lightsail Key Pair, for use with Lightsail Instances. These key pairs
 * are separate from EC2 Key Pairs, and must be created or imported for use with
 * Lightsail.
 * > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details
 * ## Example Usage
 * ### Create New Key Pair
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.KeyPair;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lgKeyPair = new KeyPair("lgKeyPair");
 *     }
 * }
 * ```
 * ### Create New Key Pair with PGP Encrypted Private Key
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.KeyPair;
 * import com.pulumi.aws.lightsail.KeyPairArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lgKeyPair = new KeyPair("lgKeyPair", KeyPairArgs.builder()
 *             .pgpKey("keybase:keybaseusername")
 *             .build());
 *     }
 * }
 * ```
 * ### Existing Public Key Import
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.KeyPair;
 * import com.pulumi.aws.lightsail.KeyPairArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lgKeyPair = new KeyPair("lgKeyPair", KeyPairArgs.builder()
 *             .publicKey(Files.readString(Paths.get("~/.ssh/id_rsa.pub")))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * You cannot import Lightsail Key Pairs because the private and public key are only available on initial creation.
 * @property name The name of the Lightsail Key Pair. If omitted, a unique name will be generated by this provider
 * @property namePrefix
 * @property pgpKey An optional PGP key to encrypt the resulting private key material. Only used when creating a new key pair
 * @property publicKey The public key material. This public key will be imported into Lightsail
 * @property tags A map of tags to assign to the collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * > **NOTE:** a PGP key is not required, however it is strongly encouraged. Without a PGP key, the private key material will be stored in state unencrypted.`pgp_key` is ignored if `public_key` is supplied.
 */
public data class KeyPairArgs(
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val pgpKey: Output<String>? = null,
    public val publicKey: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.KeyPairArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.KeyPairArgs =
        com.pulumi.aws.lightsail.KeyPairArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .pgpKey(pgpKey?.applyValue({ args0 -> args0 }))
            .publicKey(publicKey?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [KeyPairArgs].
 */
@PulumiTagMarker
public class KeyPairArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var pgpKey: Output<String>? = null

    private var publicKey: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Lightsail Key Pair. If omitted, a unique name will be generated by this provider
     */
    @JvmName("meitbvirhvrtwhot")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("ghloqmsfstgtrbef")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value An optional PGP key to encrypt the resulting private key material. Only used when creating a new key pair
     */
    @JvmName("clskdajobdqnsogt")
    public suspend fun pgpKey(`value`: Output<String>) {
        this.pgpKey = value
    }

    /**
     * @param value The public key material. This public key will be imported into Lightsail
     */
    @JvmName("plrmdhhydpqwoxxm")
    public suspend fun publicKey(`value`: Output<String>) {
        this.publicKey = value
    }

    /**
     * @param value A map of tags to assign to the collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * > **NOTE:** a PGP key is not required, however it is strongly encouraged. Without a PGP key, the private key material will be stored in state unencrypted.`pgp_key` is ignored if `public_key` is supplied.
     */
    @JvmName("vrferuqcejqtusmi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Lightsail Key Pair. If omitted, a unique name will be generated by this provider
     */
    @JvmName("cqqmpcnwmhgfqfqe")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("hpccmdxohoagjvib")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value An optional PGP key to encrypt the resulting private key material. Only used when creating a new key pair
     */
    @JvmName("kgvdnyhkowdiyxlg")
    public suspend fun pgpKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pgpKey = mapped
    }

    /**
     * @param value The public key material. This public key will be imported into Lightsail
     */
    @JvmName("keptmutpsjdxqspr")
    public suspend fun publicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKey = mapped
    }

    /**
     * @param value A map of tags to assign to the collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * > **NOTE:** a PGP key is not required, however it is strongly encouraged. Without a PGP key, the private key material will be stored in state unencrypted.`pgp_key` is ignored if `public_key` is supplied.
     */
    @JvmName("bqhdpfpmrkrrrfvq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * > **NOTE:** a PGP key is not required, however it is strongly encouraged. Without a PGP key, the private key material will be stored in state unencrypted.`pgp_key` is ignored if `public_key` is supplied.
     */
    @JvmName("juybpmwlhdbnvuie")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): KeyPairArgs = KeyPairArgs(
        name = name,
        namePrefix = namePrefix,
        pgpKey = pgpKey,
        publicKey = publicKey,
        tags = tags,
    )
}
