@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LbAttachment].
 */
@PulumiTagMarker
public class LbAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LbAttachmentArgs = LbAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LbAttachmentArgsBuilder.() -> Unit) {
        val builder = LbAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LbAttachment {
        val builtJavaResource = com.pulumi.aws.lightsail.LbAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LbAttachment(builtJavaResource)
    }
}

/**
 * Attaches a Lightsail Instance to a Lightsail Load Balancer.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.lightsail.Lb;
 * import com.pulumi.aws.lightsail.LbArgs;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.LbAttachment;
 * import com.pulumi.aws.lightsail.LbAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .filters(GetAvailabilityZonesFilterArgs.builder()
 *                 .name("opt-in-status")
 *                 .values("opt-in-not-required")
 *                 .build())
 *             .build());
 *         var testLb = new Lb("testLb", LbArgs.builder()
 *             .healthCheckPath("/")
 *             .instancePort("80")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *         var testInstance = new Instance("testInstance", InstanceArgs.builder()
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_1_0")
 *             .build());
 *         var testLbAttachment = new LbAttachment("testLbAttachment", LbAttachmentArgs.builder()
 *             .lbName(testLb.name())
 *             .instanceName(testInstance.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_lb_attachment` using the name attribute. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/lbAttachment:LbAttachment test example-load-balancer,example-instance
 * ```
 *
 */
public class LbAttachment internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.LbAttachment,
) : KotlinCustomResource(javaResource, LbAttachmentMapper) {
    /**
     * The name of the instance to attach to the load balancer.
     */
    public val instanceName: Output<String>
        get() = javaResource.instanceName().applyValue({ args0 -> args0 })

    /**
     * The name of the Lightsail load balancer.
     */
    public val lbName: Output<String>
        get() = javaResource.lbName().applyValue({ args0 -> args0 })
}

public object LbAttachmentMapper : ResourceMapper<LbAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.LbAttachment::class == javaResource::class

    override fun map(javaResource: Resource): LbAttachment = LbAttachment(
        javaResource as
            com.pulumi.aws.lightsail.LbAttachment,
    )
}

/**
 * @see [LbAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LbAttachment].
 */
public suspend fun lbAttachment(
    name: String,
    block: suspend LbAttachmentResourceBuilder.() -> Unit,
): LbAttachment {
    val builder = LbAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LbAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun lbAttachment(name: String): LbAttachment {
    val builder = LbAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
