@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.LbAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Attaches a Lightsail Instance to a Lightsail Load Balancer.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.lightsail.Lb;
 * import com.pulumi.aws.lightsail.LbArgs;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.LbAttachment;
 * import com.pulumi.aws.lightsail.LbAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .filters(GetAvailabilityZonesFilterArgs.builder()
 *                 .name("opt-in-status")
 *                 .values("opt-in-not-required")
 *                 .build())
 *             .build());
 *         var testLb = new Lb("testLb", LbArgs.builder()
 *             .healthCheckPath("/")
 *             .instancePort("80")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *         var testInstance = new Instance("testInstance", InstanceArgs.builder()
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_1_0")
 *             .build());
 *         var testLbAttachment = new LbAttachment("testLbAttachment", LbAttachmentArgs.builder()
 *             .lbName(testLb.name())
 *             .instanceName(testInstance.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_lb_attachment` using the name attribute. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/lbAttachment:LbAttachment test example-load-balancer,example-instance
 * ```
 * @property instanceName The name of the instance to attach to the load balancer.
 * @property lbName The name of the Lightsail load balancer.
 */
public data class LbAttachmentArgs(
    public val instanceName: Output<String>? = null,
    public val lbName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.LbAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.LbAttachmentArgs =
        com.pulumi.aws.lightsail.LbAttachmentArgs.builder()
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .lbName(lbName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LbAttachmentArgs].
 */
@PulumiTagMarker
public class LbAttachmentArgsBuilder internal constructor() {
    private var instanceName: Output<String>? = null

    private var lbName: Output<String>? = null

    /**
     * @param value The name of the instance to attach to the load balancer.
     */
    @JvmName("sywvvtetqgmmwhsk")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The name of the Lightsail load balancer.
     */
    @JvmName("rotydbxxcwdqydbd")
    public suspend fun lbName(`value`: Output<String>) {
        this.lbName = value
    }

    /**
     * @param value The name of the instance to attach to the load balancer.
     */
    @JvmName("amsjdjylyxqhpgwi")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The name of the Lightsail load balancer.
     */
    @JvmName("jgyrpbkqinntbnsq")
    public suspend fun lbName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lbName = mapped
    }

    internal fun build(): LbAttachmentArgs = LbAttachmentArgs(
        instanceName = instanceName,
        lbName = lbName,
    )
}
