@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LbCertificateAttachment].
 */
@PulumiTagMarker
public class LbCertificateAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LbCertificateAttachmentArgs = LbCertificateAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LbCertificateAttachmentArgsBuilder.() -> Unit) {
        val builder = LbCertificateAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LbCertificateAttachment {
        val builtJavaResource =
            com.pulumi.aws.lightsail.LbCertificateAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LbCertificateAttachment(builtJavaResource)
    }
}

/**
 * Attaches a Lightsail Load Balancer Certificate to a Lightsail Load Balancer.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Lb;
 * import com.pulumi.aws.lightsail.LbArgs;
 * import com.pulumi.aws.lightsail.LbCertificate;
 * import com.pulumi.aws.lightsail.LbCertificateArgs;
 * import com.pulumi.aws.lightsail.LbCertificateAttachment;
 * import com.pulumi.aws.lightsail.LbCertificateAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testLb = new Lb("testLb", LbArgs.builder()
 *             .healthCheckPath("/")
 *             .instancePort("80")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *         var testLbCertificate = new LbCertificate("testLbCertificate", LbCertificateArgs.builder()
 *             .lbName(testLb.id())
 *             .domainName("test.com")
 *             .build());
 *         var testLbCertificateAttachment = new LbCertificateAttachment("testLbCertificateAttachment", LbCertificateAttachmentArgs.builder()
 *             .lbName(testLb.name())
 *             .certificateName(testLbCertificate.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_lb_certificate_attachment` using the name attribute. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/lbCertificateAttachment:LbCertificateAttachment test example-load-balancer,example-certificate
 * ```
 *
 */
public class LbCertificateAttachment internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.LbCertificateAttachment,
) : KotlinCustomResource(javaResource, LbCertificateAttachmentMapper) {
    /**
     * The name of your SSL/TLS certificate.
     */
    public val certificateName: Output<String>
        get() = javaResource.certificateName().applyValue({ args0 -> args0 })

    /**
     * The name of the load balancer to which you want to associate the SSL/TLS certificate.
     */
    public val lbName: Output<String>
        get() = javaResource.lbName().applyValue({ args0 -> args0 })
}

public object LbCertificateAttachmentMapper : ResourceMapper<LbCertificateAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.LbCertificateAttachment::class == javaResource::class

    override fun map(javaResource: Resource): LbCertificateAttachment =
        LbCertificateAttachment(javaResource as com.pulumi.aws.lightsail.LbCertificateAttachment)
}

/**
 * @see [LbCertificateAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LbCertificateAttachment].
 */
public suspend fun lbCertificateAttachment(
    name: String,
    block: suspend LbCertificateAttachmentResourceBuilder.() -> Unit,
): LbCertificateAttachment {
    val builder = LbCertificateAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LbCertificateAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun lbCertificateAttachment(name: String): LbCertificateAttachment {
    val builder = LbCertificateAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
