@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.LbCertificateAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Attaches a Lightsail Load Balancer Certificate to a Lightsail Load Balancer.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Lb;
 * import com.pulumi.aws.lightsail.LbArgs;
 * import com.pulumi.aws.lightsail.LbCertificate;
 * import com.pulumi.aws.lightsail.LbCertificateArgs;
 * import com.pulumi.aws.lightsail.LbCertificateAttachment;
 * import com.pulumi.aws.lightsail.LbCertificateAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testLb = new Lb("testLb", LbArgs.builder()
 *             .healthCheckPath("/")
 *             .instancePort("80")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *         var testLbCertificate = new LbCertificate("testLbCertificate", LbCertificateArgs.builder()
 *             .lbName(testLb.id())
 *             .domainName("test.com")
 *             .build());
 *         var testLbCertificateAttachment = new LbCertificateAttachment("testLbCertificateAttachment", LbCertificateAttachmentArgs.builder()
 *             .lbName(testLb.name())
 *             .certificateName(testLbCertificate.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_lb_certificate_attachment` using the name attribute. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/lbCertificateAttachment:LbCertificateAttachment test example-load-balancer,example-certificate
 * ```
 * @property certificateName The name of your SSL/TLS certificate.
 * @property lbName The name of the load balancer to which you want to associate the SSL/TLS certificate.
 */
public data class LbCertificateAttachmentArgs(
    public val certificateName: Output<String>? = null,
    public val lbName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.LbCertificateAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.LbCertificateAttachmentArgs =
        com.pulumi.aws.lightsail.LbCertificateAttachmentArgs.builder()
            .certificateName(certificateName?.applyValue({ args0 -> args0 }))
            .lbName(lbName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LbCertificateAttachmentArgs].
 */
@PulumiTagMarker
public class LbCertificateAttachmentArgsBuilder internal constructor() {
    private var certificateName: Output<String>? = null

    private var lbName: Output<String>? = null

    /**
     * @param value The name of your SSL/TLS certificate.
     */
    @JvmName("didaoaocgklbfuok")
    public suspend fun certificateName(`value`: Output<String>) {
        this.certificateName = value
    }

    /**
     * @param value The name of the load balancer to which you want to associate the SSL/TLS certificate.
     */
    @JvmName("skkwmrspebqhadap")
    public suspend fun lbName(`value`: Output<String>) {
        this.lbName = value
    }

    /**
     * @param value The name of your SSL/TLS certificate.
     */
    @JvmName("wawxnudgjrwjjdta")
    public suspend fun certificateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateName = mapped
    }

    /**
     * @param value The name of the load balancer to which you want to associate the SSL/TLS certificate.
     */
    @JvmName("vdaawwrmvaibfcxy")
    public suspend fun lbName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lbName = mapped
    }

    internal fun build(): LbCertificateAttachmentArgs = LbCertificateAttachmentArgs(
        certificateName = certificateName,
        lbName = lbName,
    )
}
