@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LbHttpsRedirectionPolicy].
 */
@PulumiTagMarker
public class LbHttpsRedirectionPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LbHttpsRedirectionPolicyArgs = LbHttpsRedirectionPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LbHttpsRedirectionPolicyArgsBuilder.() -> Unit) {
        val builder = LbHttpsRedirectionPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LbHttpsRedirectionPolicy {
        val builtJavaResource =
            com.pulumi.aws.lightsail.LbHttpsRedirectionPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LbHttpsRedirectionPolicy(builtJavaResource)
    }
}

/**
 * Configures Https Redirection for a Lightsail Load Balancer. A valid Certificate must be attached to the load balancer in order to enable https redirection.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Lb;
 * import com.pulumi.aws.lightsail.LbArgs;
 * import com.pulumi.aws.lightsail.LbCertificate;
 * import com.pulumi.aws.lightsail.LbCertificateArgs;
 * import com.pulumi.aws.lightsail.LbCertificateAttachment;
 * import com.pulumi.aws.lightsail.LbCertificateAttachmentArgs;
 * import com.pulumi.aws.lightsail.LbHttpsRedirectionPolicy;
 * import com.pulumi.aws.lightsail.LbHttpsRedirectionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testLb = new Lb("testLb", LbArgs.builder()
 *             .healthCheckPath("/")
 *             .instancePort("80")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *         var testLbCertificate = new LbCertificate("testLbCertificate", LbCertificateArgs.builder()
 *             .lbName(testLb.id())
 *             .domainName("test.com")
 *             .build());
 *         var testLbCertificateAttachment = new LbCertificateAttachment("testLbCertificateAttachment", LbCertificateAttachmentArgs.builder()
 *             .lbName(testLb.name())
 *             .certificateName(testLbCertificate.name())
 *             .build());
 *         var testLbHttpsRedirectionPolicy = new LbHttpsRedirectionPolicy("testLbHttpsRedirectionPolicy", LbHttpsRedirectionPolicyArgs.builder()
 *             .lbName(testLb.name())
 *             .enabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_lb_https_redirection_policy` using the `lb_name` attribute. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/lbHttpsRedirectionPolicy:LbHttpsRedirectionPolicy test example-load-balancer
 * ```
 *
 */
public class LbHttpsRedirectionPolicy internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.LbHttpsRedirectionPolicy,
) : KotlinCustomResource(javaResource, LbHttpsRedirectionPolicyMapper) {
    /**
     * The Https Redirection state of the load balancer. `true` to activate http to https redirection or `false` to deactivate http to https redirection.
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * The name of the load balancer to which you want to enable http to https redirection.
     */
    public val lbName: Output<String>
        get() = javaResource.lbName().applyValue({ args0 -> args0 })
}

public object LbHttpsRedirectionPolicyMapper : ResourceMapper<LbHttpsRedirectionPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.LbHttpsRedirectionPolicy::class == javaResource::class

    override fun map(javaResource: Resource): LbHttpsRedirectionPolicy =
        LbHttpsRedirectionPolicy(javaResource as com.pulumi.aws.lightsail.LbHttpsRedirectionPolicy)
}

/**
 * @see [LbHttpsRedirectionPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LbHttpsRedirectionPolicy].
 */
public suspend fun lbHttpsRedirectionPolicy(
    name: String,
    block: suspend LbHttpsRedirectionPolicyResourceBuilder.() -> Unit,
): LbHttpsRedirectionPolicy {
    val builder = LbHttpsRedirectionPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LbHttpsRedirectionPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun lbHttpsRedirectionPolicy(name: String): LbHttpsRedirectionPolicy {
    val builder = LbHttpsRedirectionPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
