@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.LbHttpsRedirectionPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configures Https Redirection for a Lightsail Load Balancer. A valid Certificate must be attached to the load balancer in order to enable https redirection.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Lb;
 * import com.pulumi.aws.lightsail.LbArgs;
 * import com.pulumi.aws.lightsail.LbCertificate;
 * import com.pulumi.aws.lightsail.LbCertificateArgs;
 * import com.pulumi.aws.lightsail.LbCertificateAttachment;
 * import com.pulumi.aws.lightsail.LbCertificateAttachmentArgs;
 * import com.pulumi.aws.lightsail.LbHttpsRedirectionPolicy;
 * import com.pulumi.aws.lightsail.LbHttpsRedirectionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testLb = new Lb("testLb", LbArgs.builder()
 *             .healthCheckPath("/")
 *             .instancePort("80")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *         var testLbCertificate = new LbCertificate("testLbCertificate", LbCertificateArgs.builder()
 *             .lbName(testLb.id())
 *             .domainName("test.com")
 *             .build());
 *         var testLbCertificateAttachment = new LbCertificateAttachment("testLbCertificateAttachment", LbCertificateAttachmentArgs.builder()
 *             .lbName(testLb.name())
 *             .certificateName(testLbCertificate.name())
 *             .build());
 *         var testLbHttpsRedirectionPolicy = new LbHttpsRedirectionPolicy("testLbHttpsRedirectionPolicy", LbHttpsRedirectionPolicyArgs.builder()
 *             .lbName(testLb.name())
 *             .enabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_lb_https_redirection_policy` using the `lb_name` attribute. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/lbHttpsRedirectionPolicy:LbHttpsRedirectionPolicy test example-load-balancer
 * ```
 * @property enabled The Https Redirection state of the load balancer. `true` to activate http to https redirection or `false` to deactivate http to https redirection.
 * @property lbName The name of the load balancer to which you want to enable http to https redirection.
 */
public data class LbHttpsRedirectionPolicyArgs(
    public val enabled: Output<Boolean>? = null,
    public val lbName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.LbHttpsRedirectionPolicyArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.LbHttpsRedirectionPolicyArgs =
        com.pulumi.aws.lightsail.LbHttpsRedirectionPolicyArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .lbName(lbName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LbHttpsRedirectionPolicyArgs].
 */
@PulumiTagMarker
public class LbHttpsRedirectionPolicyArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var lbName: Output<String>? = null

    /**
     * @param value The Https Redirection state of the load balancer. `true` to activate http to https redirection or `false` to deactivate http to https redirection.
     */
    @JvmName("mcjsvwdmqycesieq")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The name of the load balancer to which you want to enable http to https redirection.
     */
    @JvmName("lpnqxsjhgxajeuxp")
    public suspend fun lbName(`value`: Output<String>) {
        this.lbName = value
    }

    /**
     * @param value The Https Redirection state of the load balancer. `true` to activate http to https redirection or `false` to deactivate http to https redirection.
     */
    @JvmName("pukqxiydqvrmmkoo")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The name of the load balancer to which you want to enable http to https redirection.
     */
    @JvmName("ajvymetautjmqymu")
    public suspend fun lbName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lbName = mapped
    }

    internal fun build(): LbHttpsRedirectionPolicyArgs = LbHttpsRedirectionPolicyArgs(
        enabled = enabled,
        lbName = lbName,
    )
}
