@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.LbStickinessPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configures Session Stickiness for a Lightsail Load Balancer.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Lb;
 * import com.pulumi.aws.lightsail.LbArgs;
 * import com.pulumi.aws.lightsail.LbStickinessPolicy;
 * import com.pulumi.aws.lightsail.LbStickinessPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testLb = new Lb("testLb", LbArgs.builder()
 *             .healthCheckPath("/")
 *             .instancePort("80")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *         var testLbStickinessPolicy = new LbStickinessPolicy("testLbStickinessPolicy", LbStickinessPolicyArgs.builder()
 *             .lbName(testLb.name())
 *             .cookieDuration(900)
 *             .enabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_lb_stickiness_policy` using the `lb_name` attribute. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/lbStickinessPolicy:LbStickinessPolicy test example-load-balancer
 * ```
 * @property cookieDuration The cookie duration in seconds. This determines the length of the session stickiness.
 * @property enabled The Session Stickiness state of the load balancer. `true` to activate session stickiness or `false` to deactivate session stickiness.
 * @property lbName The name of the load balancer to which you want to enable session stickiness.
 */
public data class LbStickinessPolicyArgs(
    public val cookieDuration: Output<Int>? = null,
    public val enabled: Output<Boolean>? = null,
    public val lbName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.LbStickinessPolicyArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.LbStickinessPolicyArgs =
        com.pulumi.aws.lightsail.LbStickinessPolicyArgs.builder()
            .cookieDuration(cookieDuration?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .lbName(lbName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LbStickinessPolicyArgs].
 */
@PulumiTagMarker
public class LbStickinessPolicyArgsBuilder internal constructor() {
    private var cookieDuration: Output<Int>? = null

    private var enabled: Output<Boolean>? = null

    private var lbName: Output<String>? = null

    /**
     * @param value The cookie duration in seconds. This determines the length of the session stickiness.
     */
    @JvmName("riisdquxrmjbnyrk")
    public suspend fun cookieDuration(`value`: Output<Int>) {
        this.cookieDuration = value
    }

    /**
     * @param value The Session Stickiness state of the load balancer. `true` to activate session stickiness or `false` to deactivate session stickiness.
     */
    @JvmName("igkvvisogqbumshh")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The name of the load balancer to which you want to enable session stickiness.
     */
    @JvmName("dmrsmfqoioiaudho")
    public suspend fun lbName(`value`: Output<String>) {
        this.lbName = value
    }

    /**
     * @param value The cookie duration in seconds. This determines the length of the session stickiness.
     */
    @JvmName("fkvpqsidaiocqutw")
    public suspend fun cookieDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookieDuration = mapped
    }

    /**
     * @param value The Session Stickiness state of the load balancer. `true` to activate session stickiness or `false` to deactivate session stickiness.
     */
    @JvmName("vrhuoxylojksbgoi")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The name of the load balancer to which you want to enable session stickiness.
     */
    @JvmName("iqcwoucicytdesky")
    public suspend fun lbName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lbName = mapped
    }

    internal fun build(): LbStickinessPolicyArgs = LbStickinessPolicyArgs(
        cookieDuration = cookieDuration,
        enabled = enabled,
        lbName = lbName,
    )
}
