@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.StaticIpArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Allocates a static IP address.
 * > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.StaticIp;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new StaticIp("test");
 *     }
 * }
 * ```
 * @property name The name for the allocated static IP
 */
public data class StaticIpArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.StaticIpArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.StaticIpArgs =
        com.pulumi.aws.lightsail.StaticIpArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StaticIpArgs].
 */
@PulumiTagMarker
public class StaticIpArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value The name for the allocated static IP
     */
    @JvmName("lcgipdxmwmxqxrgb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name for the allocated static IP
     */
    @JvmName("klnimcpvyxuvpfid")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): StaticIpArgs = StaticIpArgs(
        name = name,
    )
}
