@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [StaticIpAttachment].
 */
@PulumiTagMarker
public class StaticIpAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StaticIpAttachmentArgs = StaticIpAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StaticIpAttachmentArgsBuilder.() -> Unit) {
        val builder = StaticIpAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): StaticIpAttachment {
        val builtJavaResource = com.pulumi.aws.lightsail.StaticIpAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StaticIpAttachment(builtJavaResource)
    }
}

/**
 * Provides a static IP address attachment - relationship between a Lightsail static IP & Lightsail instance.
 * > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.StaticIp;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.StaticIpAttachment;
 * import com.pulumi.aws.lightsail.StaticIpAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testStaticIp = new StaticIp("testStaticIp");
 *         var testInstance = new Instance("testInstance", InstanceArgs.builder()
 *             .availabilityZone("us-east-1b")
 *             .blueprintId("string")
 *             .bundleId("string")
 *             .keyPairName("some_key_name")
 *             .build());
 *         var testStaticIpAttachment = new StaticIpAttachment("testStaticIpAttachment", StaticIpAttachmentArgs.builder()
 *             .staticIpName(testStaticIp.id())
 *             .instanceName(testInstance.id())
 *             .build());
 *     }
 * }
 * ```
 */
public class StaticIpAttachment internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.StaticIpAttachment,
) : KotlinCustomResource(javaResource, StaticIpAttachmentMapper) {
    /**
     * The name of the Lightsail instance to attach the IP to
     */
    public val instanceName: Output<String>
        get() = javaResource.instanceName().applyValue({ args0 -> args0 })

    /**
     * The allocated static IP address
     */
    public val ipAddress: Output<String>
        get() = javaResource.ipAddress().applyValue({ args0 -> args0 })

    /**
     * The name of the allocated static IP
     */
    public val staticIpName: Output<String>
        get() = javaResource.staticIpName().applyValue({ args0 -> args0 })
}

public object StaticIpAttachmentMapper : ResourceMapper<StaticIpAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.StaticIpAttachment::class == javaResource::class

    override fun map(javaResource: Resource): StaticIpAttachment = StaticIpAttachment(
        javaResource as
            com.pulumi.aws.lightsail.StaticIpAttachment,
    )
}

/**
 * @see [StaticIpAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StaticIpAttachment].
 */
public suspend fun staticIpAttachment(
    name: String,
    block: suspend StaticIpAttachmentResourceBuilder.() -> Unit,
): StaticIpAttachment {
    val builder = StaticIpAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StaticIpAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun staticIpAttachment(name: String): StaticIpAttachment {
    val builder = StaticIpAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
