@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.StaticIpAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a static IP address attachment - relationship between a Lightsail static IP & Lightsail instance.
 * > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.StaticIp;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.StaticIpAttachment;
 * import com.pulumi.aws.lightsail.StaticIpAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testStaticIp = new StaticIp("testStaticIp");
 *         var testInstance = new Instance("testInstance", InstanceArgs.builder()
 *             .availabilityZone("us-east-1b")
 *             .blueprintId("string")
 *             .bundleId("string")
 *             .keyPairName("some_key_name")
 *             .build());
 *         var testStaticIpAttachment = new StaticIpAttachment("testStaticIpAttachment", StaticIpAttachmentArgs.builder()
 *             .staticIpName(testStaticIp.id())
 *             .instanceName(testInstance.id())
 *             .build());
 *     }
 * }
 * ```
 * @property instanceName The name of the Lightsail instance to attach the IP to
 * @property staticIpName The name of the allocated static IP
 */
public data class StaticIpAttachmentArgs(
    public val instanceName: Output<String>? = null,
    public val staticIpName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.StaticIpAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.StaticIpAttachmentArgs =
        com.pulumi.aws.lightsail.StaticIpAttachmentArgs.builder()
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .staticIpName(staticIpName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StaticIpAttachmentArgs].
 */
@PulumiTagMarker
public class StaticIpAttachmentArgsBuilder internal constructor() {
    private var instanceName: Output<String>? = null

    private var staticIpName: Output<String>? = null

    /**
     * @param value The name of the Lightsail instance to attach the IP to
     */
    @JvmName("lnxrvwflsohtwynq")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The name of the allocated static IP
     */
    @JvmName("sqlaobfwqaqtaeip")
    public suspend fun staticIpName(`value`: Output<String>) {
        this.staticIpName = value
    }

    /**
     * @param value The name of the Lightsail instance to attach the IP to
     */
    @JvmName("vnurgdkohaicuwiu")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The name of the allocated static IP
     */
    @JvmName("btcxeixsngeoyped")
    public suspend fun staticIpName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staticIpName = mapped
    }

    internal fun build(): StaticIpAttachmentArgs = StaticIpAttachmentArgs(
        instanceName = instanceName,
        staticIpName = staticIpName,
    )
}
