@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.inputs

import com.pulumi.aws.lightsail.inputs.ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property healthyThreshold The number of consecutive health checks successes required before moving the container to the Healthy state. Defaults to 2.
 * @property intervalSeconds The approximate interval, in seconds, between health checks of an individual container. You can specify between 5 and 300 seconds. Defaults to 5.
 * @property path The path on the container on which to perform the health check. Defaults to "/".
 * @property successCodes The HTTP codes to use when checking for a successful response from a container. You can specify values between 200 and 499. Defaults to "200-499".
 * @property timeoutSeconds The amount of time, in seconds, during which no response means a failed health check. You can specify between 2 and 60 seconds. Defaults to 2.
 * @property unhealthyThreshold The number of consecutive health checks failures required before moving the container to the Unhealthy state. Defaults to 2.
 */
public data class ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgs(
    public val healthyThreshold: Output<Int>? = null,
    public val intervalSeconds: Output<Int>? = null,
    public val path: Output<String>? = null,
    public val successCodes: Output<String>? = null,
    public val timeoutSeconds: Output<Int>? = null,
    public val unhealthyThreshold: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.lightsail.inputs.ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgs> {
    override fun toJava():
        com.pulumi.aws.lightsail.inputs.ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgs =
        com.pulumi.aws.lightsail.inputs.ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgs.builder()
            .healthyThreshold(healthyThreshold?.applyValue({ args0 -> args0 }))
            .intervalSeconds(intervalSeconds?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .successCodes(successCodes?.applyValue({ args0 -> args0 }))
            .timeoutSeconds(timeoutSeconds?.applyValue({ args0 -> args0 }))
            .unhealthyThreshold(unhealthyThreshold?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgs].
 */
@PulumiTagMarker
public class ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgsBuilder internal
constructor() {
    private var healthyThreshold: Output<Int>? = null

    private var intervalSeconds: Output<Int>? = null

    private var path: Output<String>? = null

    private var successCodes: Output<String>? = null

    private var timeoutSeconds: Output<Int>? = null

    private var unhealthyThreshold: Output<Int>? = null

    /**
     * @param value The number of consecutive health checks successes required before moving the container to the Healthy state. Defaults to 2.
     */
    @JvmName("jjyccyxwoehmlmrw")
    public suspend fun healthyThreshold(`value`: Output<Int>) {
        this.healthyThreshold = value
    }

    /**
     * @param value The approximate interval, in seconds, between health checks of an individual container. You can specify between 5 and 300 seconds. Defaults to 5.
     */
    @JvmName("qhvnnuvveaeaogjc")
    public suspend fun intervalSeconds(`value`: Output<Int>) {
        this.intervalSeconds = value
    }

    /**
     * @param value The path on the container on which to perform the health check. Defaults to "/".
     */
    @JvmName("cmgqmfiruqoxgdcs")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The HTTP codes to use when checking for a successful response from a container. You can specify values between 200 and 499. Defaults to "200-499".
     */
    @JvmName("jjjbetwgndjcfsdd")
    public suspend fun successCodes(`value`: Output<String>) {
        this.successCodes = value
    }

    /**
     * @param value The amount of time, in seconds, during which no response means a failed health check. You can specify between 2 and 60 seconds. Defaults to 2.
     */
    @JvmName("gxojmviryfqifgkw")
    public suspend fun timeoutSeconds(`value`: Output<Int>) {
        this.timeoutSeconds = value
    }

    /**
     * @param value The number of consecutive health checks failures required before moving the container to the Unhealthy state. Defaults to 2.
     */
    @JvmName("mtxtnoxgnyqgxahx")
    public suspend fun unhealthyThreshold(`value`: Output<Int>) {
        this.unhealthyThreshold = value
    }

    /**
     * @param value The number of consecutive health checks successes required before moving the container to the Healthy state. Defaults to 2.
     */
    @JvmName("wipkdnqyyvfmfubh")
    public suspend fun healthyThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthyThreshold = mapped
    }

    /**
     * @param value The approximate interval, in seconds, between health checks of an individual container. You can specify between 5 and 300 seconds. Defaults to 5.
     */
    @JvmName("snkyfdmgmrrjvith")
    public suspend fun intervalSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intervalSeconds = mapped
    }

    /**
     * @param value The path on the container on which to perform the health check. Defaults to "/".
     */
    @JvmName("yepofyftevtfeoxc")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value The HTTP codes to use when checking for a successful response from a container. You can specify values between 200 and 499. Defaults to "200-499".
     */
    @JvmName("btltmlhvnoghmimu")
    public suspend fun successCodes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successCodes = mapped
    }

    /**
     * @param value The amount of time, in seconds, during which no response means a failed health check. You can specify between 2 and 60 seconds. Defaults to 2.
     */
    @JvmName("nndiwrwdayhvkuvj")
    public suspend fun timeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutSeconds = mapped
    }

    /**
     * @param value The number of consecutive health checks failures required before moving the container to the Unhealthy state. Defaults to 2.
     */
    @JvmName("mjshjuxmraehukmk")
    public suspend fun unhealthyThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unhealthyThreshold = mapped
    }

    internal fun build(): ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgs =
        ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgs(
            healthyThreshold = healthyThreshold,
            intervalSeconds = intervalSeconds,
            path = path,
            successCodes = successCodes,
            timeoutSeconds = timeoutSeconds,
            unhealthyThreshold = unhealthyThreshold,
        )
}
