@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.inputs

import com.pulumi.aws.lightsail.inputs.ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property isActive A Boolean value that indicates whether to activate the role. The default is `false`.
 * @property principalArn The principal ARN of the container service. The principal ARN can be used to create a trust
 * relationship between your standard AWS account and your Lightsail container service. This allows you to give your
 * service permission to access resources in your standard AWS account.
 */
public data class ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgs(
    public val isActive: Output<Boolean>? = null,
    public val principalArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.lightsail.inputs.ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgs> {
    override fun toJava():
        com.pulumi.aws.lightsail.inputs.ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgs =
        com.pulumi.aws.lightsail.inputs.ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgs.builder()
            .isActive(isActive?.applyValue({ args0 -> args0 }))
            .principalArn(principalArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgs].
 */
@PulumiTagMarker
public class ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgsBuilder internal
constructor() {
    private var isActive: Output<Boolean>? = null

    private var principalArn: Output<String>? = null

    /**
     * @param value A Boolean value that indicates whether to activate the role. The default is `false`.
     */
    @JvmName("dnmttdykyqxsyfke")
    public suspend fun isActive(`value`: Output<Boolean>) {
        this.isActive = value
    }

    /**
     * @param value The principal ARN of the container service. The principal ARN can be used to create a trust
     * relationship between your standard AWS account and your Lightsail container service. This allows you to give your
     * service permission to access resources in your standard AWS account.
     */
    @JvmName("ojwwplcqwdtbcapx")
    public suspend fun principalArn(`value`: Output<String>) {
        this.principalArn = value
    }

    /**
     * @param value A Boolean value that indicates whether to activate the role. The default is `false`.
     */
    @JvmName("bhpkiyuhhhfetcwb")
    public suspend fun isActive(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isActive = mapped
    }

    /**
     * @param value The principal ARN of the container service. The principal ARN can be used to create a trust
     * relationship between your standard AWS account and your Lightsail container service. This allows you to give your
     * service permission to access resources in your standard AWS account.
     */
    @JvmName("cgmxlbrqdnjbfwkn")
    public suspend fun principalArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalArn = mapped
    }

    internal fun build(): ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgs =
        ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgs(
            isActive = isActive,
            principalArn = principalArn,
        )
}
