@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.inputs

import com.pulumi.aws.lightsail.inputs.ContainerServicePublicDomainNamesCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property certificateName
 * @property domainNames
 */
public data class ContainerServicePublicDomainNamesCertificateArgs(
    public val certificateName: Output<String>,
    public val domainNames: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.lightsail.inputs.ContainerServicePublicDomainNamesCertificateArgs> {
    override fun toJava():
        com.pulumi.aws.lightsail.inputs.ContainerServicePublicDomainNamesCertificateArgs =
        com.pulumi.aws.lightsail.inputs.ContainerServicePublicDomainNamesCertificateArgs.builder()
            .certificateName(certificateName.applyValue({ args0 -> args0 }))
            .domainNames(domainNames.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ContainerServicePublicDomainNamesCertificateArgs].
 */
@PulumiTagMarker
public class ContainerServicePublicDomainNamesCertificateArgsBuilder internal constructor() {
    private var certificateName: Output<String>? = null

    private var domainNames: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("ncxwcnarowumjikv")
    public suspend fun certificateName(`value`: Output<String>) {
        this.certificateName = value
    }

    /**
     * @param value
     */
    @JvmName("xpoumtdcevpovptt")
    public suspend fun domainNames(`value`: Output<List<String>>) {
        this.domainNames = value
    }

    @JvmName("gnvwhfyjbhjocntr")
    public suspend fun domainNames(vararg values: Output<String>) {
        this.domainNames = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("toarxfgfpotqwtly")
    public suspend fun domainNames(values: List<Output<String>>) {
        this.domainNames = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ffrnxpxdgpwbvcmj")
    public suspend fun certificateName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateName = mapped
    }

    /**
     * @param value
     */
    @JvmName("ctgjqupepmkwvjas")
    public suspend fun domainNames(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainNames = mapped
    }

    /**
     * @param values
     */
    @JvmName("hgiuhexduthgjaew")
    public suspend fun domainNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainNames = mapped
    }

    internal fun build(): ContainerServicePublicDomainNamesCertificateArgs =
        ContainerServicePublicDomainNamesCertificateArgs(
            certificateName = certificateName ?: throw PulumiNullFieldException("certificateName"),
            domainNames = domainNames ?: throw PulumiNullFieldException("domainNames"),
        )
}
