@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.inputs

import com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsForwardedCookiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property cookiesAllowLists The specific cookies to forward to your distribution's origin.
 * @property option Specifies which cookies to forward to the distribution's origin for a cache behavior: all, none, or allow-list to forward only the cookies specified in the cookiesAllowList parameter.
 */
public data class DistributionCacheBehaviorSettingsForwardedCookiesArgs(
    public val cookiesAllowLists: Output<List<String>>? = null,
    public val option: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsForwardedCookiesArgs> {
    override fun toJava():
        com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsForwardedCookiesArgs =
        com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsForwardedCookiesArgs.builder()
            .cookiesAllowLists(cookiesAllowLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .option(option?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributionCacheBehaviorSettingsForwardedCookiesArgs].
 */
@PulumiTagMarker
public class DistributionCacheBehaviorSettingsForwardedCookiesArgsBuilder internal constructor() {
    private var cookiesAllowLists: Output<List<String>>? = null

    private var option: Output<String>? = null

    /**
     * @param value The specific cookies to forward to your distribution's origin.
     */
    @JvmName("exmwxwyhsifepbnb")
    public suspend fun cookiesAllowLists(`value`: Output<List<String>>) {
        this.cookiesAllowLists = value
    }

    @JvmName("xktefcgwhsscvmhv")
    public suspend fun cookiesAllowLists(vararg values: Output<String>) {
        this.cookiesAllowLists = Output.all(values.asList())
    }

    /**
     * @param values The specific cookies to forward to your distribution's origin.
     */
    @JvmName("txukjpxwhtqfbhve")
    public suspend fun cookiesAllowLists(values: List<Output<String>>) {
        this.cookiesAllowLists = Output.all(values)
    }

    /**
     * @param value Specifies which cookies to forward to the distribution's origin for a cache behavior: all, none, or allow-list to forward only the cookies specified in the cookiesAllowList parameter.
     */
    @JvmName("ncmggavcyaathqlv")
    public suspend fun option(`value`: Output<String>) {
        this.option = value
    }

    /**
     * @param value The specific cookies to forward to your distribution's origin.
     */
    @JvmName("lhpvhskutxahwceh")
    public suspend fun cookiesAllowLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookiesAllowLists = mapped
    }

    /**
     * @param values The specific cookies to forward to your distribution's origin.
     */
    @JvmName("aihxufftfynhnqry")
    public suspend fun cookiesAllowLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cookiesAllowLists = mapped
    }

    /**
     * @param value Specifies which cookies to forward to the distribution's origin for a cache behavior: all, none, or allow-list to forward only the cookies specified in the cookiesAllowList parameter.
     */
    @JvmName("swydwxusfslrqijs")
    public suspend fun option(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.option = mapped
    }

    internal fun build(): DistributionCacheBehaviorSettingsForwardedCookiesArgs =
        DistributionCacheBehaviorSettingsForwardedCookiesArgs(
            cookiesAllowLists = cookiesAllowLists,
            option = option,
        )
}
