@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.inputs

import com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsForwardedHeadersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property headersAllowLists The specific headers to forward to your distribution's origin.
 * @property option The headers that you want your distribution to forward to your origin and base caching on.
 */
public data class DistributionCacheBehaviorSettingsForwardedHeadersArgs(
    public val headersAllowLists: Output<List<String>>? = null,
    public val option: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsForwardedHeadersArgs> {
    override fun toJava():
        com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsForwardedHeadersArgs =
        com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsForwardedHeadersArgs.builder()
            .headersAllowLists(headersAllowLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .option(option?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributionCacheBehaviorSettingsForwardedHeadersArgs].
 */
@PulumiTagMarker
public class DistributionCacheBehaviorSettingsForwardedHeadersArgsBuilder internal constructor() {
    private var headersAllowLists: Output<List<String>>? = null

    private var option: Output<String>? = null

    /**
     * @param value The specific headers to forward to your distribution's origin.
     */
    @JvmName("swademuhumgrqudk")
    public suspend fun headersAllowLists(`value`: Output<List<String>>) {
        this.headersAllowLists = value
    }

    @JvmName("ehiqaslptoeqlvgu")
    public suspend fun headersAllowLists(vararg values: Output<String>) {
        this.headersAllowLists = Output.all(values.asList())
    }

    /**
     * @param values The specific headers to forward to your distribution's origin.
     */
    @JvmName("vdqniksycgiumfly")
    public suspend fun headersAllowLists(values: List<Output<String>>) {
        this.headersAllowLists = Output.all(values)
    }

    /**
     * @param value The headers that you want your distribution to forward to your origin and base caching on.
     */
    @JvmName("fbvixskhnpwtnhtt")
    public suspend fun option(`value`: Output<String>) {
        this.option = value
    }

    /**
     * @param value The specific headers to forward to your distribution's origin.
     */
    @JvmName("gepblsywsnfkknqw")
    public suspend fun headersAllowLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headersAllowLists = mapped
    }

    /**
     * @param values The specific headers to forward to your distribution's origin.
     */
    @JvmName("cwgfywuwridmwhut")
    public suspend fun headersAllowLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headersAllowLists = mapped
    }

    /**
     * @param value The headers that you want your distribution to forward to your origin and base caching on.
     */
    @JvmName("rovaulkyctodenkd")
    public suspend fun option(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.option = mapped
    }

    internal fun build(): DistributionCacheBehaviorSettingsForwardedHeadersArgs =
        DistributionCacheBehaviorSettingsForwardedHeadersArgs(
            headersAllowLists = headersAllowLists,
            option = option,
        )
}
