@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.inputs

import com.pulumi.aws.lightsail.inputs.DistributionOriginArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the origin resource. Your origin can be an instance with an attached static IP, a bucket, or a load balancer that has at least one instance attached to it.
 * @property protocolPolicy The protocol that your Amazon Lightsail distribution uses when establishing a connection with your origin to pull content.
 * @property regionName The AWS Region name of the origin resource.
 * @property resourceType The resource type of the origin resource (e.g., Instance).
 */
public data class DistributionOriginArgs(
    public val name: Output<String>,
    public val protocolPolicy: Output<String>? = null,
    public val regionName: Output<String>,
    public val resourceType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.inputs.DistributionOriginArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.inputs.DistributionOriginArgs =
        com.pulumi.aws.lightsail.inputs.DistributionOriginArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .protocolPolicy(protocolPolicy?.applyValue({ args0 -> args0 }))
            .regionName(regionName.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributionOriginArgs].
 */
@PulumiTagMarker
public class DistributionOriginArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var protocolPolicy: Output<String>? = null

    private var regionName: Output<String>? = null

    private var resourceType: Output<String>? = null

    /**
     * @param value The name of the origin resource. Your origin can be an instance with an attached static IP, a bucket, or a load balancer that has at least one instance attached to it.
     */
    @JvmName("vmuodwsvyyoyoovi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The protocol that your Amazon Lightsail distribution uses when establishing a connection with your origin to pull content.
     */
    @JvmName("hkfnsgskfflxsvgu")
    public suspend fun protocolPolicy(`value`: Output<String>) {
        this.protocolPolicy = value
    }

    /**
     * @param value The AWS Region name of the origin resource.
     */
    @JvmName("agljedmrjblxyqsa")
    public suspend fun regionName(`value`: Output<String>) {
        this.regionName = value
    }

    /**
     * @param value The resource type of the origin resource (e.g., Instance).
     */
    @JvmName("cqpnwccvnwycjvbh")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value The name of the origin resource. Your origin can be an instance with an attached static IP, a bucket, or a load balancer that has at least one instance attached to it.
     */
    @JvmName("nwovcksmngstbmwa")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The protocol that your Amazon Lightsail distribution uses when establishing a connection with your origin to pull content.
     */
    @JvmName("aspmgolfsqpsbcqd")
    public suspend fun protocolPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocolPolicy = mapped
    }

    /**
     * @param value The AWS Region name of the origin resource.
     */
    @JvmName("mtfjohxyngyohkso")
    public suspend fun regionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionName = mapped
    }

    /**
     * @param value The resource type of the origin resource (e.g., Instance).
     */
    @JvmName("vmyjeqatpisqqmfv")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    internal fun build(): DistributionOriginArgs = DistributionOriginArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        protocolPolicy = protocolPolicy,
        regionName = regionName ?: throw PulumiNullFieldException("regionName"),
        resourceType = resourceType,
    )
}
