@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.inputs

import com.pulumi.aws.lightsail.inputs.InstanceAddOnArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property snapshotTime The daily time when an automatic snapshot will be created. Must be in HH:00 format, and in an hourly increment and specified in Coordinated Universal Time (UTC). The snapshot will be automatically created between the time specified and up to 45 minutes after.
 * @property status The status of the add on. Valid Values: `Enabled`, `Disabled`.
 * @property type The add-on type. There is currently only one valid type `AutoSnapshot`.
 */
public data class InstanceAddOnArgs(
    public val snapshotTime: Output<String>,
    public val status: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lightsail.inputs.InstanceAddOnArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.inputs.InstanceAddOnArgs =
        com.pulumi.aws.lightsail.inputs.InstanceAddOnArgs.builder()
            .snapshotTime(snapshotTime.applyValue({ args0 -> args0 }))
            .status(status.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceAddOnArgs].
 */
@PulumiTagMarker
public class InstanceAddOnArgsBuilder internal constructor() {
    private var snapshotTime: Output<String>? = null

    private var status: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The daily time when an automatic snapshot will be created. Must be in HH:00 format, and in an hourly increment and specified in Coordinated Universal Time (UTC). The snapshot will be automatically created between the time specified and up to 45 minutes after.
     */
    @JvmName("kpjcwrmbdspuajnf")
    public suspend fun snapshotTime(`value`: Output<String>) {
        this.snapshotTime = value
    }

    /**
     * @param value The status of the add on. Valid Values: `Enabled`, `Disabled`.
     */
    @JvmName("bimjxlrqctcqdoij")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The add-on type. There is currently only one valid type `AutoSnapshot`.
     */
    @JvmName("mhmukpyciykxkixu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The daily time when an automatic snapshot will be created. Must be in HH:00 format, and in an hourly increment and specified in Coordinated Universal Time (UTC). The snapshot will be automatically created between the time specified and up to 45 minutes after.
     */
    @JvmName("jcjeygumnuixqboy")
    public suspend fun snapshotTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.snapshotTime = mapped
    }

    /**
     * @param value The status of the add on. Valid Values: `Enabled`, `Disabled`.
     */
    @JvmName("ajhdjyssksjlhvvw")
    public suspend fun status(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The add-on type. There is currently only one valid type `AutoSnapshot`.
     */
    @JvmName("iiyrfqldntuehrup")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): InstanceAddOnArgs = InstanceAddOnArgs(
        snapshotTime = snapshotTime ?: throw PulumiNullFieldException("snapshotTime"),
        status = status ?: throw PulumiNullFieldException("status"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
