@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property containerName The name of the container for the endpoint.
 * @property containerPort The port of the container to which traffic is forwarded to.
 * @property healthCheck A configuration block that describes the health check configuration of the container. Detailed below.
 */
public data class ContainerServiceDeploymentVersionPublicEndpoint(
    public val containerName: String,
    public val containerPort: Int,
    public val healthCheck: ContainerServiceDeploymentVersionPublicEndpointHealthCheck,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.lightsail.outputs.ContainerServiceDeploymentVersionPublicEndpoint):
            ContainerServiceDeploymentVersionPublicEndpoint =
            ContainerServiceDeploymentVersionPublicEndpoint(
                containerName = javaType.containerName(),
                containerPort = javaType.containerPort(),
                healthCheck = javaType.healthCheck().let({ args0 ->
                    com.pulumi.aws.lightsail.kotlin.outputs.ContainerServiceDeploymentVersionPublicEndpointHealthCheck.Companion.toKotlin(args0)
                }),
            )
    }
}
