@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property healthyThreshold The number of consecutive health checks successes required before moving the container to the Healthy state. Defaults to 2.
 * @property intervalSeconds The approximate interval, in seconds, between health checks of an individual container. You can specify between 5 and 300 seconds. Defaults to 5.
 * @property path The path on the container on which to perform the health check. Defaults to "/".
 * @property successCodes The HTTP codes to use when checking for a successful response from a container. You can specify values between 200 and 499. Defaults to "200-499".
 * @property timeoutSeconds The amount of time, in seconds, during which no response means a failed health check. You can specify between 2 and 60 seconds. Defaults to 2.
 * @property unhealthyThreshold The number of consecutive health checks failures required before moving the container to the Unhealthy state. Defaults to 2.
 */
public data class ContainerServiceDeploymentVersionPublicEndpointHealthCheck(
    public val healthyThreshold: Int? = null,
    public val intervalSeconds: Int? = null,
    public val path: String? = null,
    public val successCodes: String? = null,
    public val timeoutSeconds: Int? = null,
    public val unhealthyThreshold: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.lightsail.outputs.ContainerServiceDeploymentVersionPublicEndpointHealthCheck):
            ContainerServiceDeploymentVersionPublicEndpointHealthCheck =
            ContainerServiceDeploymentVersionPublicEndpointHealthCheck(
                healthyThreshold = javaType.healthyThreshold().map({ args0 -> args0 }).orElse(null),
                intervalSeconds = javaType.intervalSeconds().map({ args0 -> args0 }).orElse(null),
                path = javaType.path().map({ args0 -> args0 }).orElse(null),
                successCodes = javaType.successCodes().map({ args0 -> args0 }).orElse(null),
                timeoutSeconds = javaType.timeoutSeconds().map({ args0 -> args0 }).orElse(null),
                unhealthyThreshold = javaType.unhealthyThreshold().map({ args0 -> args0 }).orElse(null),
            )
    }
}
