@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property allowedHttpMethods The HTTP methods that are processed and forwarded to the distribution's origin.
 * @property cachedHttpMethods The HTTP method responses that are cached by your distribution.
 * @property defaultTtl The default amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the content has been updated.
 * @property forwardedCookies An object that describes the cookies that are forwarded to the origin. Your content is cached based on the cookies that are forwarded. Detailed below
 * @property forwardedHeaders An object that describes the headers that are forwarded to the origin. Your content is cached based on the headers that are forwarded. Detailed below
 * @property forwardedQueryStrings An object that describes the query strings that are forwarded to the origin. Your content is cached based on the query strings that are forwarded. Detailed below
 * @property maximumTtl The maximum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
 * @property minimumTtl The minimum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
 */
public data class DistributionCacheBehaviorSettings(
    public val allowedHttpMethods: String? = null,
    public val cachedHttpMethods: String? = null,
    public val defaultTtl: Int? = null,
    public val forwardedCookies: DistributionCacheBehaviorSettingsForwardedCookies? = null,
    public val forwardedHeaders: DistributionCacheBehaviorSettingsForwardedHeaders? = null,
    public val forwardedQueryStrings: DistributionCacheBehaviorSettingsForwardedQueryStrings? = null,
    public val maximumTtl: Int? = null,
    public val minimumTtl: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.lightsail.outputs.DistributionCacheBehaviorSettings):
            DistributionCacheBehaviorSettings = DistributionCacheBehaviorSettings(
            allowedHttpMethods = javaType.allowedHttpMethods().map({ args0 -> args0 }).orElse(null),
            cachedHttpMethods = javaType.cachedHttpMethods().map({ args0 -> args0 }).orElse(null),
            defaultTtl = javaType.defaultTtl().map({ args0 -> args0 }).orElse(null),
            forwardedCookies = javaType.forwardedCookies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lightsail.kotlin.outputs.DistributionCacheBehaviorSettingsForwardedCookies.Companion.toKotlin(args0)
                })
            }).orElse(null),
            forwardedHeaders = javaType.forwardedHeaders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lightsail.kotlin.outputs.DistributionCacheBehaviorSettingsForwardedHeaders.Companion.toKotlin(args0)
                })
            }).orElse(null),
            forwardedQueryStrings = javaType.forwardedQueryStrings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lightsail.kotlin.outputs.DistributionCacheBehaviorSettingsForwardedQueryStrings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            maximumTtl = javaType.maximumTtl().map({ args0 -> args0 }).orElse(null),
            minimumTtl = javaType.minimumTtl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
