@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property option Indicates whether the distribution forwards and caches based on query strings.
 * @property queryStringsAllowedLists The specific query strings that the distribution forwards to the origin.
 */
public data class DistributionCacheBehaviorSettingsForwardedQueryStrings(
    public val option: Boolean? = null,
    public val queryStringsAllowedLists: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.lightsail.outputs.DistributionCacheBehaviorSettingsForwardedQueryStrings):
            DistributionCacheBehaviorSettingsForwardedQueryStrings =
            DistributionCacheBehaviorSettingsForwardedQueryStrings(
                option = javaType.option().map({ args0 -> args0 }).orElse(null),
                queryStringsAllowedLists = javaType.queryStringsAllowedLists().map({ args0 -> args0 }),
            )
    }
}
