@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property availabilityZone The Availability Zone. Follows the format us-east-2a (case-sensitive).
 * @property regionName The AWS Region name of the origin resource.
 */
public data class DistributionLocation(
    public val availabilityZone: String,
    public val regionName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lightsail.outputs.DistributionLocation):
            DistributionLocation = DistributionLocation(
            availabilityZone = javaType.availabilityZone(),
            regionName = javaType.regionName(),
        )
    }
}
