@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property snapshotTime The daily time when an automatic snapshot will be created. Must be in HH:00 format, and in an hourly increment and specified in Coordinated Universal Time (UTC). The snapshot will be automatically created between the time specified and up to 45 minutes after.
 * @property status The status of the add on. Valid Values: `Enabled`, `Disabled`.
 * @property type The add-on type. There is currently only one valid type `AutoSnapshot`.
 */
public data class InstanceAddOn(
    public val snapshotTime: String,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lightsail.outputs.InstanceAddOn): InstanceAddOn =
            InstanceAddOn(
                snapshotTime = javaType.snapshotTime(),
                status = javaType.status(),
                type = javaType.type(),
            )
    }
}
