@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property domainName The domain name (e.g., example.com) for your SSL/TLS certificate.
 * @property resourceRecordName
 * @property resourceRecordType
 * @property resourceRecordValue
 */
public data class LbCertificateDomainValidationRecord(
    public val domainName: String? = null,
    public val resourceRecordName: String? = null,
    public val resourceRecordType: String? = null,
    public val resourceRecordValue: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.lightsail.outputs.LbCertificateDomainValidationRecord):
            LbCertificateDomainValidationRecord = LbCertificateDomainValidationRecord(
            domainName = javaType.domainName().map({ args0 -> args0 }).orElse(null),
            resourceRecordName = javaType.resourceRecordName().map({ args0 -> args0 }).orElse(null),
            resourceRecordType = javaType.resourceRecordType().map({ args0 -> args0 }).orElse(null),
            resourceRecordValue = javaType.resourceRecordValue().map({ args0 -> args0 }).orElse(null),
        )
    }
}
