@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [GeofenceCollection].
 */
@PulumiTagMarker
public class GeofenceCollectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GeofenceCollectionArgs = GeofenceCollectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GeofenceCollectionArgsBuilder.() -> Unit) {
        val builder = GeofenceCollectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GeofenceCollection {
        val builtJavaResource = com.pulumi.aws.location.GeofenceCollection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GeofenceCollection(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Location Geofence Collection.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.location.GeofenceCollection;
 * import com.pulumi.aws.location.GeofenceCollectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GeofenceCollection("example", GeofenceCollectionArgs.builder()
 *             .collectionName("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Location Geofence Collection using the `collection_name`. For example:
 * ```sh
 *  $ pulumi import aws:location/geofenceCollection:GeofenceCollection example example
 * ```
 *
 */
public class GeofenceCollection internal constructor(
    override val javaResource: com.pulumi.aws.location.GeofenceCollection,
) : KotlinCustomResource(javaResource, GeofenceCollectionMapper) {
    /**
     * The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a resource across all AWS.
     */
    public val collectionArn: Output<String>
        get() = javaResource.collectionArn().applyValue({ args0 -> args0 })

    /**
     * The name of the geofence collection.
     * The following arguments are optional:
     */
    public val collectionName: Output<String>
        get() = javaResource.collectionName().applyValue({ args0 -> args0 })

    /**
     * The timestamp for when the geofence collection resource was created in ISO 8601 format.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The optional description for the geofence collection.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A key identifier for an AWS KMS customer managed key assigned to the Amazon Location resource.
     */
    public val kmsKeyId: Output<String>?
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Key-value tags for the geofence collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The timestamp for when the geofence collection resource was last updated in ISO 8601 format.
     */
    public val updateTime: Output<String>
        get() = javaResource.updateTime().applyValue({ args0 -> args0 })
}

public object GeofenceCollectionMapper : ResourceMapper<GeofenceCollection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.location.GeofenceCollection::class == javaResource::class

    override fun map(javaResource: Resource): GeofenceCollection = GeofenceCollection(
        javaResource as
            com.pulumi.aws.location.GeofenceCollection,
    )
}

/**
 * @see [GeofenceCollection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GeofenceCollection].
 */
public suspend fun geofenceCollection(
    name: String,
    block: suspend GeofenceCollectionResourceBuilder.() -> Unit,
): GeofenceCollection {
    val builder = GeofenceCollectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GeofenceCollection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun geofenceCollection(name: String): GeofenceCollection {
    val builder = GeofenceCollectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
