@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin

import com.pulumi.aws.location.GeofenceCollectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Location Geofence Collection.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.location.GeofenceCollection;
 * import com.pulumi.aws.location.GeofenceCollectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GeofenceCollection("example", GeofenceCollectionArgs.builder()
 *             .collectionName("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Location Geofence Collection using the `collection_name`. For example:
 * ```sh
 *  $ pulumi import aws:location/geofenceCollection:GeofenceCollection example example
 * ```
 * @property collectionName The name of the geofence collection.
 * The following arguments are optional:
 * @property description The optional description for the geofence collection.
 * @property kmsKeyId A key identifier for an AWS KMS customer managed key assigned to the Amazon Location resource.
 * @property tags Key-value tags for the geofence collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class GeofenceCollectionArgs(
    public val collectionName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.location.GeofenceCollectionArgs> {
    override fun toJava(): com.pulumi.aws.location.GeofenceCollectionArgs =
        com.pulumi.aws.location.GeofenceCollectionArgs.builder()
            .collectionName(collectionName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GeofenceCollectionArgs].
 */
@PulumiTagMarker
public class GeofenceCollectionArgsBuilder internal constructor() {
    private var collectionName: Output<String>? = null

    private var description: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the geofence collection.
     * The following arguments are optional:
     */
    @JvmName("ubavoyljodyyljwm")
    public suspend fun collectionName(`value`: Output<String>) {
        this.collectionName = value
    }

    /**
     * @param value The optional description for the geofence collection.
     */
    @JvmName("mwtkwlcvixtauygu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A key identifier for an AWS KMS customer managed key assigned to the Amazon Location resource.
     */
    @JvmName("ruhonbixealnjbkj")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Key-value tags for the geofence collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iipdyqnklsrwvaec")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the geofence collection.
     * The following arguments are optional:
     */
    @JvmName("rmurmmxweobganum")
    public suspend fun collectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectionName = mapped
    }

    /**
     * @param value The optional description for the geofence collection.
     */
    @JvmName("wjuikeqkymlmuqbr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A key identifier for an AWS KMS customer managed key assigned to the Amazon Location resource.
     */
    @JvmName("mamwrosfiynnutyn")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Key-value tags for the geofence collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jphgoxfqmjxnsnhg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the geofence collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eanxeculvilqasyb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): GeofenceCollectionArgs = GeofenceCollectionArgs(
        collectionName = collectionName,
        description = description,
        kmsKeyId = kmsKeyId,
        tags = tags,
    )
}
