@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin

import com.pulumi.aws.location.kotlin.outputs.MapConfiguration
import com.pulumi.aws.location.kotlin.outputs.MapConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Map].
 */
@PulumiTagMarker
public class MapResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MapArgs = MapArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MapArgsBuilder.() -> Unit) {
        val builder = MapArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Map {
        val builtJavaResource = com.pulumi.aws.location.Map(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Map(builtJavaResource)
    }
}

/**
 * Provides a Location Service Map.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.location.Map;
 * import com.pulumi.aws.location.MapArgs;
 * import com.pulumi.aws.location.inputs.MapConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Map("example", MapArgs.builder()
 *             .configuration(MapConfigurationArgs.builder()
 *                 .style("VectorHereBerlin")
 *                 .build())
 *             .mapName("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_location_map` resources using the map name. For example:
 * ```sh
 *  $ pulumi import aws:location/map:Map example example
 * ```
 *
 */
public class Map internal constructor(
    override val javaResource: com.pulumi.aws.location.Map,
) : KotlinCustomResource(javaResource, MapMapper) {
    /**
     * Configuration block with the map style selected from an available data provider. Detailed below.
     */
    public val configuration: Output<MapConfiguration>
        get() = javaResource.configuration().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The timestamp for when the map resource was created in ISO 8601 format.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * An optional description for the map resource.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all AWS.
     */
    public val mapArn: Output<String>
        get() = javaResource.mapArn().applyValue({ args0 -> args0 })

    /**
     * The name for the map resource.
     * The following arguments are optional:
     */
    public val mapName: Output<String>
        get() = javaResource.mapName().applyValue({ args0 -> args0 })

    /**
     * Key-value tags for the map. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<kotlin.collections.Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<kotlin.collections.Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The timestamp for when the map resource was last updated in ISO 8601 format.
     */
    public val updateTime: Output<String>
        get() = javaResource.updateTime().applyValue({ args0 -> args0 })
}

public object MapMapper : ResourceMapper<Map> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.location.Map::class == javaResource::class

    override fun map(javaResource: Resource): Map = Map(javaResource as com.pulumi.aws.location.Map)
}

/**
 * @see [Map].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Map].
 */
public suspend fun map(name: String, block: suspend MapResourceBuilder.() -> Unit): Map {
    val builder = MapResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Map].
 * @param name The _unique_ name of the resulting resource.
 */
public fun map(name: String): Map {
    val builder = MapResourceBuilder()
    builder.name(name)
    return builder.build()
}
