@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin

import com.pulumi.aws.location.MapArgs.builder
import com.pulumi.aws.location.kotlin.inputs.MapConfigurationArgs
import com.pulumi.aws.location.kotlin.inputs.MapConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Location Service Map.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.location.Map;
 * import com.pulumi.aws.location.MapArgs;
 * import com.pulumi.aws.location.inputs.MapConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Map("example", MapArgs.builder()
 *             .configuration(MapConfigurationArgs.builder()
 *                 .style("VectorHereBerlin")
 *                 .build())
 *             .mapName("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_location_map` resources using the map name. For example:
 * ```sh
 *  $ pulumi import aws:location/map:Map example example
 * ```
 * @property configuration Configuration block with the map style selected from an available data provider. Detailed below.
 * @property description An optional description for the map resource.
 * @property mapName The name for the map resource.
 * The following arguments are optional:
 * @property tags Key-value tags for the map. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class MapArgs(
    public val configuration: Output<MapConfigurationArgs>? = null,
    public val description: Output<String>? = null,
    public val mapName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.location.MapArgs> {
    override fun toJava(): com.pulumi.aws.location.MapArgs = com.pulumi.aws.location.MapArgs.builder()
        .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .description(description?.applyValue({ args0 -> args0 }))
        .mapName(mapName?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [MapArgs].
 */
@PulumiTagMarker
public class MapArgsBuilder internal constructor() {
    private var configuration: Output<MapConfigurationArgs>? = null

    private var description: Output<String>? = null

    private var mapName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Configuration block with the map style selected from an available data provider. Detailed below.
     */
    @JvmName("urndnuiuynorukmv")
    public suspend fun configuration(`value`: Output<MapConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value An optional description for the map resource.
     */
    @JvmName("citeppjorruplclx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name for the map resource.
     * The following arguments are optional:
     */
    @JvmName("bsknaxkuveheetve")
    public suspend fun mapName(`value`: Output<String>) {
        this.mapName = value
    }

    /**
     * @param value Key-value tags for the map. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("aslyukjuthsobdiw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block with the map style selected from an available data provider. Detailed below.
     */
    @JvmName("rweswemskjqlyarp")
    public suspend fun configuration(`value`: MapConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument Configuration block with the map style selected from an available data provider. Detailed below.
     */
    @JvmName("sjfhtpwaqmddhvmv")
    public suspend fun configuration(argument: suspend MapConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = MapConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value An optional description for the map resource.
     */
    @JvmName("umwckgcfxcuggqkw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name for the map resource.
     * The following arguments are optional:
     */
    @JvmName("rtdvnojlqofrfgww")
    public suspend fun mapName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mapName = mapped
    }

    /**
     * @param value Key-value tags for the map. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sdakqhybdxxbkkyw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the map. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tyfbdqogxuoqywqq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MapArgs = MapArgs(
        configuration = configuration,
        description = description,
        mapName = mapName,
        tags = tags,
    )
}
