@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin

import com.pulumi.aws.location.kotlin.outputs.PlaceIndexDataSourceConfiguration
import com.pulumi.aws.location.kotlin.outputs.PlaceIndexDataSourceConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [PlaceIndex].
 */
@PulumiTagMarker
public class PlaceIndexResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PlaceIndexArgs = PlaceIndexArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PlaceIndexArgsBuilder.() -> Unit) {
        val builder = PlaceIndexArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PlaceIndex {
        val builtJavaResource = com.pulumi.aws.location.PlaceIndex(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PlaceIndex(builtJavaResource)
    }
}

/**
 * Provides a Location Service Place Index.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.location.PlaceIndex;
 * import com.pulumi.aws.location.PlaceIndexArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PlaceIndex("example", PlaceIndexArgs.builder()
 *             .dataSource("Here")
 *             .indexName("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_location_place_index` resources using the place index name. For example:
 * ```sh
 *  $ pulumi import aws:location/placeIndex:PlaceIndex example example
 * ```
 *
 */
public class PlaceIndex internal constructor(
    override val javaResource: com.pulumi.aws.location.PlaceIndex,
) : KotlinCustomResource(javaResource, PlaceIndexMapper) {
    /**
     * The timestamp for when the place index resource was created in ISO 8601 format.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Specifies the geospatial data provider for the new place index.
     */
    public val dataSource: Output<String>
        get() = javaResource.dataSource().applyValue({ args0 -> args0 })

    /**
     * Configuration block with the data storage option chosen for requesting Places. Detailed below.
     */
    public val dataSourceConfiguration: Output<PlaceIndexDataSourceConfiguration>
        get() = javaResource.dataSourceConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The optional description for the place index resource.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across AWS.
     */
    public val indexArn: Output<String>
        get() = javaResource.indexArn().applyValue({ args0 -> args0 })

    /**
     * The name of the place index resource.
     * The following arguments are optional:
     */
    public val indexName: Output<String>
        get() = javaResource.indexName().applyValue({ args0 -> args0 })

    /**
     * Key-value tags for the place index. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The timestamp for when the place index resource was last update in ISO 8601.
     */
    public val updateTime: Output<String>
        get() = javaResource.updateTime().applyValue({ args0 -> args0 })
}

public object PlaceIndexMapper : ResourceMapper<PlaceIndex> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.location.PlaceIndex::class == javaResource::class

    override fun map(javaResource: Resource): PlaceIndex = PlaceIndex(
        javaResource as
            com.pulumi.aws.location.PlaceIndex,
    )
}

/**
 * @see [PlaceIndex].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PlaceIndex].
 */
public suspend fun placeIndex(name: String, block: suspend PlaceIndexResourceBuilder.() -> Unit):
    PlaceIndex {
    val builder = PlaceIndexResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PlaceIndex].
 * @param name The _unique_ name of the resulting resource.
 */
public fun placeIndex(name: String): PlaceIndex {
    val builder = PlaceIndexResourceBuilder()
    builder.name(name)
    return builder.build()
}
