@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin

import com.pulumi.aws.location.PlaceIndexArgs.builder
import com.pulumi.aws.location.kotlin.inputs.PlaceIndexDataSourceConfigurationArgs
import com.pulumi.aws.location.kotlin.inputs.PlaceIndexDataSourceConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Location Service Place Index.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.location.PlaceIndex;
 * import com.pulumi.aws.location.PlaceIndexArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PlaceIndex("example", PlaceIndexArgs.builder()
 *             .dataSource("Here")
 *             .indexName("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_location_place_index` resources using the place index name. For example:
 * ```sh
 *  $ pulumi import aws:location/placeIndex:PlaceIndex example example
 * ```
 * @property dataSource Specifies the geospatial data provider for the new place index.
 * @property dataSourceConfiguration Configuration block with the data storage option chosen for requesting Places. Detailed below.
 * @property description The optional description for the place index resource.
 * @property indexName The name of the place index resource.
 * The following arguments are optional:
 * @property tags Key-value tags for the place index. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class PlaceIndexArgs(
    public val dataSource: Output<String>? = null,
    public val dataSourceConfiguration: Output<PlaceIndexDataSourceConfigurationArgs>? = null,
    public val description: Output<String>? = null,
    public val indexName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.location.PlaceIndexArgs> {
    override fun toJava(): com.pulumi.aws.location.PlaceIndexArgs =
        com.pulumi.aws.location.PlaceIndexArgs.builder()
            .dataSource(dataSource?.applyValue({ args0 -> args0 }))
            .dataSourceConfiguration(
                dataSourceConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .indexName(indexName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PlaceIndexArgs].
 */
@PulumiTagMarker
public class PlaceIndexArgsBuilder internal constructor() {
    private var dataSource: Output<String>? = null

    private var dataSourceConfiguration: Output<PlaceIndexDataSourceConfigurationArgs>? = null

    private var description: Output<String>? = null

    private var indexName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies the geospatial data provider for the new place index.
     */
    @JvmName("haevllhynccjjbfh")
    public suspend fun dataSource(`value`: Output<String>) {
        this.dataSource = value
    }

    /**
     * @param value Configuration block with the data storage option chosen for requesting Places. Detailed below.
     */
    @JvmName("feffgmwebbhglren")
    public suspend
    fun dataSourceConfiguration(`value`: Output<PlaceIndexDataSourceConfigurationArgs>) {
        this.dataSourceConfiguration = value
    }

    /**
     * @param value The optional description for the place index resource.
     */
    @JvmName("eutawypftjujvher")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the place index resource.
     * The following arguments are optional:
     */
    @JvmName("nmbnnxjcwsylgoso")
    public suspend fun indexName(`value`: Output<String>) {
        this.indexName = value
    }

    /**
     * @param value Key-value tags for the place index. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gnmnibhneavpudml")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the geospatial data provider for the new place index.
     */
    @JvmName("yeroasqxaxlaagqp")
    public suspend fun dataSource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSource = mapped
    }

    /**
     * @param value Configuration block with the data storage option chosen for requesting Places. Detailed below.
     */
    @JvmName("kmygcclcchlgrjaq")
    public suspend fun dataSourceConfiguration(`value`: PlaceIndexDataSourceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSourceConfiguration = mapped
    }

    /**
     * @param argument Configuration block with the data storage option chosen for requesting Places. Detailed below.
     */
    @JvmName("bbsshrbnidasqaxo")
    public suspend
    fun dataSourceConfiguration(argument: suspend PlaceIndexDataSourceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = PlaceIndexDataSourceConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dataSourceConfiguration = mapped
    }

    /**
     * @param value The optional description for the place index resource.
     */
    @JvmName("jldcdqxlhdxhgqng")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the place index resource.
     * The following arguments are optional:
     */
    @JvmName("ionkaphahfysniop")
    public suspend fun indexName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexName = mapped
    }

    /**
     * @param value Key-value tags for the place index. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lbpgiuaqshormmbb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the place index. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qyhowrcwkuiyxmpw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PlaceIndexArgs = PlaceIndexArgs(
        dataSource = dataSource,
        dataSourceConfiguration = dataSourceConfiguration,
        description = description,
        indexName = indexName,
        tags = tags,
    )
}
