@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [RouteCalculation].
 */
@PulumiTagMarker
public class RouteCalculationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouteCalculationArgs = RouteCalculationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouteCalculationArgsBuilder.() -> Unit) {
        val builder = RouteCalculationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RouteCalculation {
        val builtJavaResource = com.pulumi.aws.location.RouteCalculation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RouteCalculation(builtJavaResource)
    }
}

/**
 * Provides a Location Service Route Calculator.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.location.RouteCalculation;
 * import com.pulumi.aws.location.RouteCalculationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RouteCalculation("example", RouteCalculationArgs.builder()
 *             .calculatorName("example")
 *             .dataSource("Here")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_location_route_calculator` using the route calculator name. For example:
 * ```sh
 *  $ pulumi import aws:location/routeCalculation:RouteCalculation example example
 * ```
 *
 */
public class RouteCalculation internal constructor(
    override val javaResource: com.pulumi.aws.location.RouteCalculation,
) : KotlinCustomResource(javaResource, RouteCalculationMapper) {
    /**
     * The Amazon Resource Name (ARN) for the Route calculator resource. Use the ARN when you specify a resource across AWS.
     */
    public val calculatorArn: Output<String>
        get() = javaResource.calculatorArn().applyValue({ args0 -> args0 })

    /**
     * The name of the route calculator resource.
     */
    public val calculatorName: Output<String>
        get() = javaResource.calculatorName().applyValue({ args0 -> args0 })

    /**
     * The timestamp for when the route calculator resource was created in ISO 8601 format.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Specifies the data provider of traffic and road network data.
     * The following arguments are optional:
     */
    public val dataSource: Output<String>
        get() = javaResource.dataSource().applyValue({ args0 -> args0 })

    /**
     * The optional description for the route calculator resource.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value tags for the route calculator. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The timestamp for when the route calculator resource was last update in ISO 8601.
     */
    public val updateTime: Output<String>
        get() = javaResource.updateTime().applyValue({ args0 -> args0 })
}

public object RouteCalculationMapper : ResourceMapper<RouteCalculation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.location.RouteCalculation::class == javaResource::class

    override fun map(javaResource: Resource): RouteCalculation = RouteCalculation(
        javaResource as
            com.pulumi.aws.location.RouteCalculation,
    )
}

/**
 * @see [RouteCalculation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RouteCalculation].
 */
public suspend fun routeCalculation(
    name: String,
    block: suspend RouteCalculationResourceBuilder.() -> Unit,
): RouteCalculation {
    val builder = RouteCalculationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RouteCalculation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun routeCalculation(name: String): RouteCalculation {
    val builder = RouteCalculationResourceBuilder()
    builder.name(name)
    return builder.build()
}
