@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin

import com.pulumi.aws.location.RouteCalculationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Location Service Route Calculator.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.location.RouteCalculation;
 * import com.pulumi.aws.location.RouteCalculationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RouteCalculation("example", RouteCalculationArgs.builder()
 *             .calculatorName("example")
 *             .dataSource("Here")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_location_route_calculator` using the route calculator name. For example:
 * ```sh
 *  $ pulumi import aws:location/routeCalculation:RouteCalculation example example
 * ```
 * @property calculatorName The name of the route calculator resource.
 * @property dataSource Specifies the data provider of traffic and road network data.
 * The following arguments are optional:
 * @property description The optional description for the route calculator resource.
 * @property tags Key-value tags for the route calculator. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class RouteCalculationArgs(
    public val calculatorName: Output<String>? = null,
    public val dataSource: Output<String>? = null,
    public val description: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.location.RouteCalculationArgs> {
    override fun toJava(): com.pulumi.aws.location.RouteCalculationArgs =
        com.pulumi.aws.location.RouteCalculationArgs.builder()
            .calculatorName(calculatorName?.applyValue({ args0 -> args0 }))
            .dataSource(dataSource?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RouteCalculationArgs].
 */
@PulumiTagMarker
public class RouteCalculationArgsBuilder internal constructor() {
    private var calculatorName: Output<String>? = null

    private var dataSource: Output<String>? = null

    private var description: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the route calculator resource.
     */
    @JvmName("thonfkfikesgblbe")
    public suspend fun calculatorName(`value`: Output<String>) {
        this.calculatorName = value
    }

    /**
     * @param value Specifies the data provider of traffic and road network data.
     * The following arguments are optional:
     */
    @JvmName("cghabjglhucylnny")
    public suspend fun dataSource(`value`: Output<String>) {
        this.dataSource = value
    }

    /**
     * @param value The optional description for the route calculator resource.
     */
    @JvmName("odljecietutdgexv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Key-value tags for the route calculator. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("drxlnbssujghtgaj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the route calculator resource.
     */
    @JvmName("clkkejpfhnhmpktr")
    public suspend fun calculatorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.calculatorName = mapped
    }

    /**
     * @param value Specifies the data provider of traffic and road network data.
     * The following arguments are optional:
     */
    @JvmName("lntynqissfouxvaj")
    public suspend fun dataSource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSource = mapped
    }

    /**
     * @param value The optional description for the route calculator resource.
     */
    @JvmName("iytoreqkatlkwfrx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Key-value tags for the route calculator. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dajffsniylttsfti")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the route calculator. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xlxtnnblpivcmpju")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RouteCalculationArgs = RouteCalculationArgs(
        calculatorName = calculatorName,
        dataSource = dataSource,
        description = description,
        tags = tags,
    )
}
