@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin

import com.pulumi.aws.location.TrackerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Location Service Tracker.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.location.Tracker;
 * import com.pulumi.aws.location.TrackerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Tracker("example", TrackerArgs.builder()
 *             .trackerName("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_location_tracker` resources using the tracker name. For example:
 * ```sh
 *  $ pulumi import aws:location/tracker:Tracker example example
 * ```
 * @property description The optional description for the tracker resource.
 * @property kmsKeyId A key identifier for an AWS KMS customer managed key assigned to the Amazon Location resource.
 * @property positionFiltering The position filtering method of the tracker resource. Valid values: `TimeBased`, `DistanceBased`, `AccuracyBased`. Default: `TimeBased`.
 * @property tags Key-value tags for the tracker. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property trackerName The name of the tracker resource.
 * The following arguments are optional:
 */
public data class TrackerArgs(
    public val description: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val positionFiltering: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trackerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.location.TrackerArgs> {
    override fun toJava(): com.pulumi.aws.location.TrackerArgs =
        com.pulumi.aws.location.TrackerArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .positionFiltering(positionFiltering?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trackerName(trackerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrackerArgs].
 */
@PulumiTagMarker
public class TrackerArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var positionFiltering: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trackerName: Output<String>? = null

    /**
     * @param value The optional description for the tracker resource.
     */
    @JvmName("ahsosuxkwxwglemo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A key identifier for an AWS KMS customer managed key assigned to the Amazon Location resource.
     */
    @JvmName("xmvtlbhxcswvxyle")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The position filtering method of the tracker resource. Valid values: `TimeBased`, `DistanceBased`, `AccuracyBased`. Default: `TimeBased`.
     */
    @JvmName("tdnxoqvcuwwhmqfx")
    public suspend fun positionFiltering(`value`: Output<String>) {
        this.positionFiltering = value
    }

    /**
     * @param value Key-value tags for the tracker. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gnwigybccedeotxs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the tracker resource.
     * The following arguments are optional:
     */
    @JvmName("nbstmcyrdftjfqbb")
    public suspend fun trackerName(`value`: Output<String>) {
        this.trackerName = value
    }

    /**
     * @param value The optional description for the tracker resource.
     */
    @JvmName("biapwcnnnputoqvs")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A key identifier for an AWS KMS customer managed key assigned to the Amazon Location resource.
     */
    @JvmName("dypfmkbrwfaidkcu")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The position filtering method of the tracker resource. Valid values: `TimeBased`, `DistanceBased`, `AccuracyBased`. Default: `TimeBased`.
     */
    @JvmName("jaktrmjlmdsivoaf")
    public suspend fun positionFiltering(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.positionFiltering = mapped
    }

    /**
     * @param value Key-value tags for the tracker. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ofuebfjignppcryn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the tracker. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dymxiubafcommkfo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the tracker resource.
     * The following arguments are optional:
     */
    @JvmName("tbgoddhksqtwfbre")
    public suspend fun trackerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trackerName = mapped
    }

    internal fun build(): TrackerArgs = TrackerArgs(
        description = description,
        kmsKeyId = kmsKeyId,
        positionFiltering = positionFiltering,
        tags = tags,
        trackerName = trackerName,
    )
}
