@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin.inputs

import com.pulumi.aws.location.inputs.GetGeofenceCollectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGeofenceCollection.
 * @property collectionName Name of the geofence collection.
 * @property kmsKeyId Key identifier for an AWS KMS customer managed key assigned to the Amazon Location resource.
 * @property tags Key-value map of resource tags for the geofence collection.
 */
public data class GetGeofenceCollectionPlainArgs(
    public val collectionName: String,
    public val kmsKeyId: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.location.inputs.GetGeofenceCollectionPlainArgs> {
    override fun toJava(): com.pulumi.aws.location.inputs.GetGeofenceCollectionPlainArgs =
        com.pulumi.aws.location.inputs.GetGeofenceCollectionPlainArgs.builder()
            .collectionName(collectionName.let({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetGeofenceCollectionPlainArgs].
 */
@PulumiTagMarker
public class GetGeofenceCollectionPlainArgsBuilder internal constructor() {
    private var collectionName: String? = null

    private var kmsKeyId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the geofence collection.
     */
    @JvmName("ygyuyrmqrgcqckxl")
    public suspend fun collectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.collectionName = mapped
    }

    /**
     * @param value Key identifier for an AWS KMS customer managed key assigned to the Amazon Location resource.
     */
    @JvmName("htprwjimxoqxmxbx")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Key-value map of resource tags for the geofence collection.
     */
    @JvmName("dctcgbfrpkaasoun")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the geofence collection.
     */
    @JvmName("njrwsgfvryyvensb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetGeofenceCollectionPlainArgs = GetGeofenceCollectionPlainArgs(
        collectionName = collectionName ?: throw PulumiNullFieldException("collectionName"),
        kmsKeyId = kmsKeyId,
        tags = tags,
    )
}
