@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin.inputs

import com.pulumi.aws.location.inputs.GetMapPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getMap.
 * @property mapName Name of the map resource.
 * @property tags Key-value map of resource tags for the map.
 */
public data class GetMapPlainArgs(
    public val mapName: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.location.inputs.GetMapPlainArgs> {
    override fun toJava(): com.pulumi.aws.location.inputs.GetMapPlainArgs =
        com.pulumi.aws.location.inputs.GetMapPlainArgs.builder()
            .mapName(mapName.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetMapPlainArgs].
 */
@PulumiTagMarker
public class GetMapPlainArgsBuilder internal constructor() {
    private var mapName: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the map resource.
     */
    @JvmName("qtpokcfqbuyhltem")
    public suspend fun mapName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mapName = mapped
    }

    /**
     * @param value Key-value map of resource tags for the map.
     */
    @JvmName("nhqehcoasakjvcim")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the map.
     */
    @JvmName("qccxlpcxsdmqfphq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetMapPlainArgs = GetMapPlainArgs(
        mapName = mapName ?: throw PulumiNullFieldException("mapName"),
        tags = tags,
    )
}
