@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin.inputs

import com.pulumi.aws.location.inputs.GetPlaceIndexPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPlaceIndex.
 * @property indexName Name of the place index resource.
 * @property tags Key-value map of resource tags for the place index.
 */
public data class GetPlaceIndexPlainArgs(
    public val indexName: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.location.inputs.GetPlaceIndexPlainArgs> {
    override fun toJava(): com.pulumi.aws.location.inputs.GetPlaceIndexPlainArgs =
        com.pulumi.aws.location.inputs.GetPlaceIndexPlainArgs.builder()
            .indexName(indexName.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetPlaceIndexPlainArgs].
 */
@PulumiTagMarker
public class GetPlaceIndexPlainArgsBuilder internal constructor() {
    private var indexName: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the place index resource.
     */
    @JvmName("jkpflkwuakjacgrk")
    public suspend fun indexName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.indexName = mapped
    }

    /**
     * @param value Key-value map of resource tags for the place index.
     */
    @JvmName("cgvxtrjeuikfuojj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the place index.
     */
    @JvmName("dwymircciuigysct")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetPlaceIndexPlainArgs = GetPlaceIndexPlainArgs(
        indexName = indexName ?: throw PulumiNullFieldException("indexName"),
        tags = tags,
    )
}
