@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin.inputs

import com.pulumi.aws.location.inputs.GetRouteCalculatorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRouteCalculator.
 * @property calculatorName Name of the route calculator resource.
 * @property tags Key-value map of resource tags for the route calculator.
 */
public data class GetRouteCalculatorPlainArgs(
    public val calculatorName: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.location.inputs.GetRouteCalculatorPlainArgs> {
    override fun toJava(): com.pulumi.aws.location.inputs.GetRouteCalculatorPlainArgs =
        com.pulumi.aws.location.inputs.GetRouteCalculatorPlainArgs.builder()
            .calculatorName(calculatorName.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetRouteCalculatorPlainArgs].
 */
@PulumiTagMarker
public class GetRouteCalculatorPlainArgsBuilder internal constructor() {
    private var calculatorName: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the route calculator resource.
     */
    @JvmName("imixbtdxuqjwdfvx")
    public suspend fun calculatorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.calculatorName = mapped
    }

    /**
     * @param value Key-value map of resource tags for the route calculator.
     */
    @JvmName("gwjvuodajultxkfb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the route calculator.
     */
    @JvmName("ofosyervajigcpoo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetRouteCalculatorPlainArgs = GetRouteCalculatorPlainArgs(
        calculatorName = calculatorName ?: throw PulumiNullFieldException("calculatorName"),
        tags = tags,
    )
}
